/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.timeout;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.Query;
import org.hibernate.QueryTimeoutException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.fwk.SkipForDialect;
import org.hibernate.search.test.query.timeout.Clock;

public class TimeoutTest
extends SearchTestCase {
    public void testTimeout() {
        FullTextSession fts = Search.getFullTextSession((Session)this.openSession());
        this.storeClocks(fts);
        Transaction tx = fts.beginTransaction();
        QueryBuilder builder = fts.getSearchFactory().buildQueryBuilder().forEntity(Clock.class).get();
        Query query = builder.keyword().onField("brand").matching((Object)"Seiko").createQuery();
        FullTextQuery hibernateQuery = fts.createFullTextQuery(query, new Class[]{Clock.class});
        List results = hibernateQuery.list();
        TimeoutTest.assertEquals((int)500, (int)results.size());
        fts.clear();
        hibernateQuery.setTimeout(10L, TimeUnit.MICROSECONDS);
        long start = System.nanoTime();
        try {
            hibernateQuery.list();
            TimeoutTest.fail((String)"timeout exception should happen");
        }
        catch (QueryTimeoutException e) {
        }
        catch (Exception e) {
            TimeoutTest.fail((String)"Expected a QueryTimeoutException");
        }
        fts.clear();
        query = builder.keyword().onField("brand").matching((Object)"Swatch").createQuery();
        hibernateQuery = fts.createFullTextQuery(query, new Class[]{Clock.class});
        hibernateQuery.setTimeout(10L, TimeUnit.MICROSECONDS);
        try {
            hibernateQuery.iterate();
            TimeoutTest.fail((String)"timeout exception should happen");
        }
        catch (QueryTimeoutException e) {
        }
        catch (Exception e) {
            TimeoutTest.fail((String)"Expected a QueryTimeoutException");
        }
        fts.clear();
        query = builder.keyword().onField("brand").matching((Object)"Blah").createQuery();
        hibernateQuery = fts.createFullTextQuery(query, new Class[]{Clock.class});
        hibernateQuery.setTimeout(10L, TimeUnit.MICROSECONDS);
        try {
            hibernateQuery.scroll();
            TimeoutTest.fail((String)"timeout exception should happen");
        }
        catch (QueryTimeoutException e) {
        }
        catch (Exception e) {
            TimeoutTest.fail((String)"Expected a QueryTimeoutException");
        }
        System.out.println("Time = " + (System.nanoTime() - start));
        tx.commit();
        fts.clear();
        tx = fts.beginTransaction();
        TimeoutTest.assertEquals((int)1000, (int)fts.createQuery("delete from " + Clock.class.getName()).executeUpdate());
        tx.commit();
        fts.close();
    }

    public void testLimitFetchingTime() {
        FullTextSession fts = Search.getFullTextSession((Session)this.openSession());
        this.storeClocks(fts);
        Transaction tx = fts.beginTransaction();
        QueryBuilder builder = fts.getSearchFactory().buildQueryBuilder().forEntity(Clock.class).get();
        Query query = builder.keyword().onField("brand").matching((Object)"Seiko").createQuery();
        FullTextQuery hibernateQuery = fts.createFullTextQuery(query, new Class[]{Clock.class});
        List results = hibernateQuery.list();
        TimeoutTest.assertEquals((int)500, (int)results.size());
        fts.clear();
        query = builder.keyword().onField("brand").matching((Object)"Swatch").createQuery();
        hibernateQuery = fts.createFullTextQuery(query, new Class[]{Clock.class});
        hibernateQuery.limitExecutionTimeTo(1L, TimeUnit.NANOSECONDS);
        List result = hibernateQuery.list();
        System.out.println("Result size early: " + result.size());
        TimeoutTest.assertEquals((String)"Test early failure, before the number of results are even fetched", (int)0, (int)result.size());
        if (result.size() == 0) {
            TimeoutTest.assertTrue((boolean)hibernateQuery.hasPartialResults());
        }
        fts.clear();
        hibernateQuery = fts.createFullTextQuery(query, new Class[]{Clock.class});
        hibernateQuery.limitExecutionTimeTo(30L, TimeUnit.SECONDS);
        results = hibernateQuery.list();
        TimeoutTest.assertEquals((String)"Test below limit termination", (int)500, (int)results.size());
        TimeoutTest.assertFalse((boolean)hibernateQuery.hasPartialResults());
        tx.commit();
        fts.clear();
        tx = fts.beginTransaction();
        TimeoutTest.assertEquals((int)1000, (int)fts.createQuery("delete from " + Clock.class.getName()).executeUpdate());
        tx.commit();
        fts.close();
    }

    @SkipForDialect(value={PostgreSQLDialect.class}, jiraKey="JBPAPP-2945", comment="PostgreSQL driver does not implement query timeout")
    public void testEnoughTime() {
        FullTextSession fts = Search.getFullTextSession((Session)this.openSession());
        this.storeClocks(fts);
        Transaction tx = fts.beginTransaction();
        QueryBuilder builder = fts.getSearchFactory().buildQueryBuilder().forEntity(Clock.class).get();
        Query query = builder.all().createQuery();
        FullTextQuery hibernateQuery = fts.createFullTextQuery(query, new Class[]{Clock.class});
        hibernateQuery.setTimeout(5L, TimeUnit.MINUTES);
        List results = hibernateQuery.list();
        TimeoutTest.assertFalse((boolean)hibernateQuery.hasPartialResults());
        TimeoutTest.assertEquals((int)1000, (int)results.size());
        tx.commit();
        fts.close();
    }

    private void storeClocks(FullTextSession fts) {
        Transaction tx = fts.beginTransaction();
        for (int i = 0; i < 1000; ++i) {
            Clock clock = new Clock("Model cat A" + i, i % 2 == 0 ? "Seiko" : "Swatch", new Long(2000 + i));
            fts.persist((Object)clock);
        }
        tx.commit();
        fts.clear();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Clock.class};
    }
}

