/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.session;

import java.io.File;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.queryParser.QueryParser;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.impl.FullTextSessionImpl;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.session.Domain;
import org.hibernate.search.test.session.Email;

public class OptimizeTest
extends SearchTestCase {
    public void testOptimize() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        int loop = 2000;
        for (int i = 0; i < loop; ++i) {
            Email email = new Email();
            email.setId((long)i + 1L);
            email.setTitle("JBoss World Berlin");
            email.setBody("Meet the guys who wrote the software");
            s.persist((Object)email);
        }
        tx.commit();
        s.close();
        s = Search.getFullTextSession((Session)this.openSession());
        tx = s.beginTransaction();
        s.getSearchFactory().optimize(Email.class);
        tx.commit();
        s.close();
        s = new FullTextSessionImpl(this.openSession());
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(OptimizeTest.getTargetLuceneVersion(), "id", SearchTestCase.stopAnalyzer);
        int result = s.createFullTextQuery(parser.parse("body:wrote"), new Class[0]).getResultSize();
        OptimizeTest.assertEquals((int)2000, (int)result);
        s.createQuery("delete " + Email.class.getName()).executeUpdate();
        tx.commit();
        s.close();
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        File sub = this.getBaseIndexDir();
        cfg.setProperty("hibernate.search.default.indexBase", sub.getAbsolutePath());
        cfg.setProperty("hibernate.search.default.directory_provider", "filesystem");
        cfg.setProperty("hibernate.search.analyzer", StopAnalyzer.class.getName());
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Email.class, Domain.class};
    }
}

