/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial;

import java.io.Serializable;
import org.geolatte.geom.codec.db.oracle.ConnectionFinder;
import org.hibernate.spatial.HSMessageLogger;
import org.jboss.logging.Logger;

public class HibernateSpatialConfiguration
implements Serializable {
    private static final HSMessageLogger LOG = (HSMessageLogger)Logger.getMessageLogger(HSMessageLogger.class, (String)HibernateSpatialConfiguration.class.getName());
    private Boolean isOgcStrict = Boolean.TRUE;
    private ConnectionFinder connectionFinder;

    public HibernateSpatialConfiguration() {
    }

    public HibernateSpatialConfiguration(Boolean ogcStrict, ConnectionFinder connectionFinder) {
        if (ogcStrict != null) {
            this.isOgcStrict = ogcStrict;
            LOG.debugf("Setting OGC_STRICT mode for Oracle Spatial dialect to %s.", ogcStrict);
        }
        if (connectionFinder != null) {
            this.connectionFinder = connectionFinder;
            LOG.debugf("Using ConnectionFinder implementation:  %s (only relevant for Oracle Spatial dialect).", connectionFinder.getClass().getCanonicalName());
        }
    }

    public Boolean isOgcStrictMode() {
        return this.isOgcStrict;
    }

    public ConnectionFinder getConnectionFinder() {
        return this.connectionFinder;
    }

    public static class AvailableSettings {
        public static final String OGC_STRICT = "hibernate.spatial.ogc_strict";
        public static final String CONNECTION_FINDER = "hibernate.spatial.connection_finder";
    }
}

