/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.criterion;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.spatial.jts.EnvelopeAdapter;

public class SpatialFilter
implements Criterion {
    private static final long serialVersionUID = 1L;
    private String propertyName;
    private Geometry filter;

    public SpatialFilter(String propertyName, Geometry filter) {
        this.propertyName = propertyName;
        this.filter = filter;
    }

    public SpatialFilter(String propertyName, Envelope envelope, int srid) {
        this.propertyName = propertyName;
        this.filter = EnvelopeAdapter.toPolygon(envelope, srid);
    }

    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        return new TypedValue[]{criteriaQuery.getTypedValue(criteria, this.propertyName, (Object)this.filter)};
    }

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        SessionFactoryImplementor factory = criteriaQuery.getFactory();
        String[] columns = criteriaQuery.getColumnsUsingProjection(criteria, this.propertyName);
        Dialect dialect = factory.getDialect();
        if (dialect instanceof SpatialDialect) {
            SpatialDialect seDialect = (SpatialDialect)dialect;
            return seDialect.getSpatialFilterExpression(columns[0]);
        }
        throw new IllegalStateException("Dialect must be spatially enabled dialect");
    }
}

