/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.postgis;

import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.dialect.postgis.PGGeometryTypeDescriptor;
import org.hibernate.spatial.dialect.postgis.PostgisDialect;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class PostgisNoSQLMM
extends PostgisDialect {
    @Override
    protected void registerTypesAndFunctions() {
        this.registerColumnType(PGGeometryTypeDescriptor.INSTANCE.getSqlType(), "GEOMETRY");
        this.registerFunction("dimension", (SQLFunction)new StandardSQLFunction("dimension", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("geometrytype", (SQLFunction)new StandardSQLFunction("geometrytype", (Type)StandardBasicTypes.STRING));
        this.registerFunction("srid", (SQLFunction)new StandardSQLFunction("srid", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("envelope", (SQLFunction)new StandardSQLFunction("envelope"));
        this.registerFunction("astext", (SQLFunction)new StandardSQLFunction("astext", (Type)StandardBasicTypes.STRING));
        this.registerFunction("asbinary", (SQLFunction)new StandardSQLFunction("asbinary", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("isempty", (SQLFunction)new StandardSQLFunction("isempty", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("issimple", (SQLFunction)new StandardSQLFunction("issimple", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("boundary", (SQLFunction)new StandardSQLFunction("boundary"));
        this.registerFunction("overlaps", (SQLFunction)new StandardSQLFunction("overlaps", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("intersects", (SQLFunction)new StandardSQLFunction("intersects", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("equals", (SQLFunction)new StandardSQLFunction("equals", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("contains", (SQLFunction)new StandardSQLFunction("contains", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("crosses", (SQLFunction)new StandardSQLFunction("crosses", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("disjoint", (SQLFunction)new StandardSQLFunction("disjoint", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("touches", (SQLFunction)new StandardSQLFunction("touches", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("within", (SQLFunction)new StandardSQLFunction("within", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("relate", (SQLFunction)new StandardSQLFunction("relate", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("distance", (SQLFunction)new StandardSQLFunction("distance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("buffer", (SQLFunction)new StandardSQLFunction("buffer"));
        this.registerFunction("convexhull", (SQLFunction)new StandardSQLFunction("convexhull"));
        this.registerFunction("difference", (SQLFunction)new StandardSQLFunction("difference"));
        this.registerFunction("intersection", (SQLFunction)new StandardSQLFunction("intersection"));
        this.registerFunction("symdifference", (SQLFunction)new StandardSQLFunction("symdifference"));
        this.registerFunction("geomunion", (SQLFunction)new StandardSQLFunction("geomunion"));
        this.registerFunction("extent", (SQLFunction)new StandardSQLFunction("extent"));
        this.registerFunction("transform", (SQLFunction)new StandardSQLFunction("transform"));
    }

    @Override
    public String getDWithinSQL(String columnName) {
        return "( dwithin(" + columnName + ",?,?) )";
    }

    @Override
    public String getHavingSridSQL(String columnName) {
        return "( srid(" + columnName + ") = ?)";
    }

    @Override
    public String getIsEmptySQL(String columnName, boolean isEmpty) {
        String emptyExpr = "( isempty(" + columnName + ")) ";
        return isEmpty ? emptyExpr : "not " + emptyExpr;
    }

    @Override
    public String getSpatialRelateSQL(String columnName, int spatialRelation) {
        switch (spatialRelation) {
            case 4: {
                return "(" + columnName + " && ?  AND within(" + columnName + ", ?))";
            }
            case 6: {
                return "(" + columnName + " && ? AND contains(" + columnName + ", ?))";
            }
            case 3: {
                return "(" + columnName + " && ? AND crosses(" + columnName + ", ?))";
            }
            case 5: {
                return "(" + columnName + " && ? AND overlaps(" + columnName + ", ?))";
            }
            case 1: {
                return "(" + columnName + " && ? AND disjoint(" + columnName + ", ?))";
            }
            case 7: {
                return "(" + columnName + " && ? AND intersects(" + columnName + ", ?))";
            }
            case 2: {
                return "(" + columnName + " && ? AND touches(" + columnName + ", ?))";
            }
            case 0: {
                return "(" + columnName + " && ? AND equals(" + columnName + ", ?))";
            }
        }
        throw new IllegalArgumentException("Spatial relation is not known by this dialect");
    }

    @Override
    public boolean supports(SpatialFunction function) {
        return super.supports(function);
    }
}

