/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.h2geodb;

import com.vividsolutions.jts.geom.Envelope;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.ByteOrder;
import org.geolatte.geom.C2D;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.PositionSequenceBuilders;
import org.geolatte.geom.codec.Wkb;
import org.geolatte.geom.codec.WkbDecoder;
import org.geolatte.geom.codec.WkbEncoder;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystems;
import org.geolatte.geom.jts.JTS;
import org.hibernate.HibernateException;
import org.hibernate.spatial.HSMessageLogger;
import org.jboss.logging.Logger;

public class GeoDbWkb {
    private static final HSMessageLogger LOGGER = (HSMessageLogger)Logger.getMessageLogger(HSMessageLogger.class, (String)GeoDbWkb.class.getName());

    private GeoDbWkb() {
    }

    public static byte[] to(Geometry geometry) {
        WkbEncoder encoder = Wkb.newEncoder((Wkb.Dialect)Wkb.Dialect.POSTGIS_EWKB_1);
        ByteBuffer buffer = encoder.encode(geometry, ByteOrder.NDR);
        return buffer == null ? null : buffer.toByteArray();
    }

    public static Geometry from(Object object) {
        if (object == null) {
            return null;
        }
        try {
            if (object instanceof com.vividsolutions.jts.geom.Geometry) {
                return JTS.from((com.vividsolutions.jts.geom.Geometry)((com.vividsolutions.jts.geom.Geometry)object));
            }
            WkbDecoder decoder = Wkb.newDecoder((Wkb.Dialect)Wkb.Dialect.POSTGIS_EWKB_1);
            if (object instanceof Blob) {
                return decoder.decode(GeoDbWkb.toByteBuffer((Blob)object));
            }
            if (object instanceof byte[]) {
                return decoder.decode(ByteBuffer.from((byte[])((byte[])object)));
            }
            if (object instanceof Envelope) {
                return GeoDbWkb.toPolygon(JTS.from((Envelope)((Envelope)object)));
            }
            throw new IllegalArgumentException("Can't convert database object of type " + object.getClass().getCanonicalName());
        }
        catch (Exception e) {
            LOGGER.warn("Could not convert database object to a Geometry.");
            throw new HibernateException((Throwable)e);
        }
    }

    private static Geometry<C2D> toPolygon(org.geolatte.geom.Envelope env) {
        PositionSequence ps = PositionSequenceBuilders.fixedSized((int)4, C2D.class).add(new double[]{env.lowerLeft().getCoordinate(0), env.lowerLeft().getCoordinate(1)}).add(new double[]{env.lowerLeft().getCoordinate(0), env.upperRight().getCoordinate(1)}).add(new double[]{env.upperRight().getCoordinate(0), env.upperRight().getCoordinate(1)}).add(new double[]{env.lowerLeft().getCoordinate(0), env.lowerLeft().getCoordinate(1)}).toPositionSequence();
        return new Polygon(ps, (CoordinateReferenceSystem)CoordinateReferenceSystems.PROJECTED_2D_METER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer toByteBuffer(Blob blob) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        InputStream in = null;
        try {
            in = blob.getBinaryStream();
            int n = 0;
            while ((n = in.read(buf)) >= 0) {
                baos.write(buf, 0, n);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Could not convert database BLOB object to binary stream.", e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                LOGGER.warn("Could not close binary stream.");
            }
        }
        return ByteBuffer.from((byte[])baos.toByteArray());
    }
}

