/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.hana;

import java.util.List;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.dialect.HANAColumnStoreDialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.spatial.GeolatteGeometryJavaTypeDescriptor;
import org.hibernate.spatial.GeolatteGeometryType;
import org.hibernate.spatial.JTSGeometryJavaTypeDescriptor;
import org.hibernate.spatial.JTSGeometryType;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.dialect.hana.HANAGeometryTypeDescriptor;
import org.hibernate.spatial.dialect.hana.HANAPointTypeDescriptor;
import org.hibernate.spatial.dialect.hana.HANASpatialAggregate;
import org.hibernate.spatial.dialect.hana.HANASpatialFunction;
import org.hibernate.spatial.dialect.hana.HANASpatialFunctions;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class HANASpatialDialect
extends HANAColumnStoreDialect
implements SpatialDialect {
    private static final long serialVersionUID = -432631517465714911L;
    private static final String DETERMINE_CRS_ID_FROM_DATABASE_PARAMETER_NAME = "hibernate.spatial.dialect.hana.determine_crs_id_from_database";

    public HANASpatialDialect() {
        this.registerColumnType(HANAGeometryTypeDescriptor.INSTANCE.getSqlType(), "ST_GEOMETRY");
        this.registerColumnType(HANAPointTypeDescriptor.INSTANCE.getSqlType(), "ST_POINT");
        this.registerHibernateType(1111, new GeolatteGeometryType(HANAGeometryTypeDescriptor.INSTANCE).getName());
        this.registerFunction(SpatialFunction.asbinary.name(), (SQLFunction)new HANASpatialFunction("ST_AsBinary", (Type)StandardBasicTypes.MATERIALIZED_BLOB, false));
        this.registerFunction(SpatialFunction.astext.name(), (SQLFunction)new HANASpatialFunction("ST_AsText", (Type)StandardBasicTypes.MATERIALIZED_CLOB, false));
        this.registerFunction(SpatialFunction.boundary.name(), (SQLFunction)new HANASpatialFunction("ST_Boundary", false));
        this.registerFunction(SpatialFunction.buffer.name(), (SQLFunction)new HANASpatialFunction("ST_Buffer", false));
        this.registerFunction(SpatialFunction.contains.name(), (SQLFunction)new HANASpatialFunction("ST_Contains", (Type)StandardBasicTypes.NUMERIC_BOOLEAN, true));
        this.registerFunction(SpatialFunction.convexhull.name(), (SQLFunction)new HANASpatialFunction("ST_ConvexHull", false));
        this.registerFunction(SpatialFunction.crosses.name(), (SQLFunction)new HANASpatialFunction("ST_Crosses", (Type)StandardBasicTypes.NUMERIC_BOOLEAN, true));
        this.registerFunction(SpatialFunction.difference.name(), (SQLFunction)new HANASpatialFunction("ST_Difference", true));
        this.registerFunction(SpatialFunction.dimension.name(), (SQLFunction)new HANASpatialFunction("ST_Dimension", (Type)StandardBasicTypes.INTEGER, false));
        this.registerFunction(SpatialFunction.disjoint.name(), (SQLFunction)new HANASpatialFunction("ST_Disjoint", (Type)StandardBasicTypes.NUMERIC_BOOLEAN, true));
        this.registerFunction(SpatialFunction.distance.name(), (SQLFunction)new HANASpatialFunction("ST_Distance", (Type)StandardBasicTypes.DOUBLE, true));
        this.registerFunction(SpatialFunction.dwithin.name(), (SQLFunction)new HANASpatialFunction("ST_WithinDistance", (Type)StandardBasicTypes.NUMERIC_BOOLEAN, true));
        this.registerFunction(SpatialFunction.envelope.name(), (SQLFunction)new HANASpatialFunction("ST_Envelope", true));
        this.registerFunction(SpatialFunction.equals.name(), (SQLFunction)new HANASpatialFunction("ST_Equals", (Type)StandardBasicTypes.NUMERIC_BOOLEAN, true));
        this.registerFunction(SpatialFunction.extent.name(), (SQLFunction)new HANASpatialAggregate("ST_EnvelopeAggr"));
        this.registerFunction(SpatialFunction.geometrytype.name(), (SQLFunction)new HANASpatialFunction("ST_GeometryType", (Type)StandardBasicTypes.STRING, false));
        this.registerFunction(SpatialFunction.geomunion.name(), (SQLFunction)new HANASpatialFunction("ST_Union", true));
        this.registerFunction(SpatialFunction.intersection.name(), (SQLFunction)new HANASpatialFunction("ST_Intersection", true));
        this.registerFunction(SpatialFunction.intersects.name(), (SQLFunction)new HANASpatialFunction("ST_Intersects", (Type)StandardBasicTypes.NUMERIC_BOOLEAN, true));
        this.registerFunction(SpatialFunction.isempty.name(), (SQLFunction)new HANASpatialFunction("ST_IsEmpty", (Type)StandardBasicTypes.NUMERIC_BOOLEAN, false));
        this.registerFunction(SpatialFunction.issimple.name(), (SQLFunction)new HANASpatialFunction("ST_IsSimple", (Type)StandardBasicTypes.NUMERIC_BOOLEAN, false));
        this.registerFunction(SpatialFunction.overlaps.name(), (SQLFunction)new HANASpatialFunction("ST_Overlaps", (Type)StandardBasicTypes.NUMERIC_BOOLEAN, true));
        this.registerFunction(SpatialFunction.relate.name(), (SQLFunction)new HANASpatialFunction("ST_Relate", (Type)StandardBasicTypes.NUMERIC_BOOLEAN, true));
        this.registerFunction(SpatialFunction.srid.name(), (SQLFunction)new HANASpatialFunction("ST_SRID", (Type)StandardBasicTypes.INTEGER, false));
        this.registerFunction(SpatialFunction.symdifference.name(), (SQLFunction)new HANASpatialFunction("ST_SymDifference", true));
        this.registerFunction(SpatialFunction.touches.name(), (SQLFunction)new HANASpatialFunction("ST_Touches", (Type)StandardBasicTypes.NUMERIC_BOOLEAN, true));
        this.registerFunction(SpatialFunction.transform.name(), (SQLFunction)new HANASpatialFunction("ST_Transform", false));
        this.registerFunction(SpatialFunction.within.name(), (SQLFunction)new HANASpatialFunction("ST_Within", (Type)StandardBasicTypes.NUMERIC_BOOLEAN, true));
        this.registerFunction(SpatialFunction.filter.name(), (SQLFunction)new FilterFunction());
        this.registerFunction(HANASpatialFunctions.alphashape.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.alphashape.getFunctionName(), false));
        this.registerFunction(HANASpatialFunctions.area.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.area.getFunctionName(), (Type)StandardBasicTypes.DOUBLE, false));
        this.registerFunction(HANASpatialFunctions.asewkb.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.asewkb.getFunctionName(), (Type)StandardBasicTypes.MATERIALIZED_BLOB, false));
        this.registerFunction(HANASpatialFunctions.asewkt.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.asewkt.getFunctionName(), (Type)StandardBasicTypes.MATERIALIZED_CLOB, false));
        this.registerFunction(HANASpatialFunctions.asgeojson.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.asgeojson.getFunctionName(), (Type)StandardBasicTypes.MATERIALIZED_CLOB, false));
        this.registerFunction(HANASpatialFunctions.assvg.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.assvg.getFunctionName(), (Type)StandardBasicTypes.MATERIALIZED_CLOB, false));
        this.registerFunction(HANASpatialFunctions.assvgaggr.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.assvgaggr.getFunctionName(), (Type)StandardBasicTypes.MATERIALIZED_CLOB, false, true));
        this.registerFunction(HANASpatialFunctions.aswkb.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.aswkb.getFunctionName(), (Type)StandardBasicTypes.MATERIALIZED_BLOB, false));
        this.registerFunction(HANASpatialFunctions.aswkt.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.aswkt.getFunctionName(), (Type)StandardBasicTypes.MATERIALIZED_CLOB, false));
        this.registerFunction(HANASpatialFunctions.centroid.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.centroid.getFunctionName(), false));
        this.registerFunction(HANASpatialFunctions.convexhullaggr.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.convexhullaggr.getFunctionName(), true, true));
        this.registerFunction(HANASpatialFunctions.coorddim.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.coorddim.getFunctionName(), (Type)StandardBasicTypes.INTEGER, false));
        this.registerFunction(HANASpatialFunctions.coveredby.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.coveredby.getFunctionName(), (Type)StandardBasicTypes.NUMERIC_BOOLEAN, true));
        this.registerFunction(HANASpatialFunctions.covers.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.covers.getFunctionName(), (Type)StandardBasicTypes.NUMERIC_BOOLEAN, true));
        this.registerFunction(HANASpatialFunctions.endpoint.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.endpoint.getFunctionName(), false));
        this.registerFunction(HANASpatialFunctions.envelopeaggr.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.envelopeaggr.getFunctionName(), true, true));
        this.registerFunction(HANASpatialFunctions.exteriorring.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.exteriorring.getFunctionName(), false));
        this.registerFunction(HANASpatialFunctions.geomfromewkb.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.geomfromewkb.getFunctionName(), false, true));
        this.registerFunction(HANASpatialFunctions.geomfromewkt.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.geomfromewkt.getFunctionName(), false, true));
        this.registerFunction(HANASpatialFunctions.geomfromtext.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.geomfromtext.getFunctionName(), false, true));
        this.registerFunction(HANASpatialFunctions.geomfromwkb.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.geomfromwkb.getFunctionName(), false, true));
        this.registerFunction(HANASpatialFunctions.geomfromwkt.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.geomfromwkt.getFunctionName(), false, true));
        this.registerFunction(HANASpatialFunctions.geometryn.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.geometryn.getFunctionName(), false));
        this.registerFunction(HANASpatialFunctions.interiorringn.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.interiorringn.getFunctionName(), false));
        this.registerFunction(HANASpatialFunctions.intersectionaggr.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.intersectionaggr.getFunctionName(), true, true));
        this.registerFunction(HANASpatialFunctions.intersectsrect.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.intersectsrect.getFunctionName(), (Type)StandardBasicTypes.NUMERIC_BOOLEAN, new boolean[]{true, true}));
        this.registerFunction(HANASpatialFunctions.is3d.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.is3d.getFunctionName(), (Type)StandardBasicTypes.NUMERIC_BOOLEAN, false));
        this.registerFunction(HANASpatialFunctions.isclosed.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.isclosed.getFunctionName(), (Type)StandardBasicTypes.NUMERIC_BOOLEAN, false));
        this.registerFunction(HANASpatialFunctions.ismeasured.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.ismeasured.getFunctionName(), (Type)StandardBasicTypes.NUMERIC_BOOLEAN, false));
        this.registerFunction(HANASpatialFunctions.isring.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.isring.getFunctionName(), (Type)StandardBasicTypes.NUMERIC_BOOLEAN, false));
        this.registerFunction(HANASpatialFunctions.isvalid.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.isvalid.getFunctionName(), (Type)StandardBasicTypes.NUMERIC_BOOLEAN, false));
        this.registerFunction(HANASpatialFunctions.length.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.length.getFunctionName(), (Type)StandardBasicTypes.DOUBLE, false));
        this.registerFunction(HANASpatialFunctions.m.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.m.getFunctionName(), (Type)StandardBasicTypes.DOUBLE, false));
        this.registerFunction(HANASpatialFunctions.mmax.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.mmax.getFunctionName(), (Type)StandardBasicTypes.DOUBLE, false));
        this.registerFunction(HANASpatialFunctions.mmin.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.mmin.getFunctionName(), (Type)StandardBasicTypes.DOUBLE, false));
        this.registerFunction(HANASpatialFunctions.numgeometries.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.numgeometries.getFunctionName(), (Type)StandardBasicTypes.INTEGER, false));
        this.registerFunction(HANASpatialFunctions.numinteriorring.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.numinteriorring.getFunctionName(), (Type)StandardBasicTypes.INTEGER, false));
        this.registerFunction(HANASpatialFunctions.numinteriorrings.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.numinteriorrings.getFunctionName(), (Type)StandardBasicTypes.INTEGER, false));
        this.registerFunction(HANASpatialFunctions.numpoints.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.numpoints.getFunctionName(), (Type)StandardBasicTypes.INTEGER, false));
        this.registerFunction(HANASpatialFunctions.orderingequals.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.orderingequals.getFunctionName(), (Type)StandardBasicTypes.NUMERIC_BOOLEAN, true));
        this.registerFunction(HANASpatialFunctions.perimeter.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.perimeter.getFunctionName(), (Type)StandardBasicTypes.DOUBLE, false));
        this.registerFunction(HANASpatialFunctions.pointonsurface.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.pointonsurface.getFunctionName(), false));
        this.registerFunction(HANASpatialFunctions.pointn.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.pointn.getFunctionName(), false));
        this.registerFunction(HANASpatialFunctions.snaptogrid.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.snaptogrid.getFunctionName(), false));
        this.registerFunction(HANASpatialFunctions.startpoint.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.startpoint.getFunctionName(), false));
        this.registerFunction(HANASpatialFunctions.unionaggr.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.unionaggr.getFunctionName(), true, true));
        this.registerFunction(HANASpatialFunctions.x.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.x.getFunctionName(), (Type)StandardBasicTypes.DOUBLE, false));
        this.registerFunction(HANASpatialFunctions.xmax.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.xmax.getFunctionName(), (Type)StandardBasicTypes.DOUBLE, false));
        this.registerFunction(HANASpatialFunctions.xmin.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.xmin.getFunctionName(), (Type)StandardBasicTypes.DOUBLE, false));
        this.registerFunction(HANASpatialFunctions.y.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.y.getFunctionName(), (Type)StandardBasicTypes.DOUBLE, false));
        this.registerFunction(HANASpatialFunctions.ymax.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.ymax.getFunctionName(), (Type)StandardBasicTypes.DOUBLE, false));
        this.registerFunction(HANASpatialFunctions.ymin.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.ymin.getFunctionName(), (Type)StandardBasicTypes.DOUBLE, false));
        this.registerFunction(HANASpatialFunctions.z.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.z.getFunctionName(), (Type)StandardBasicTypes.DOUBLE, false));
        this.registerFunction(HANASpatialFunctions.zmax.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.zmax.getFunctionName(), (Type)StandardBasicTypes.DOUBLE, false));
        this.registerFunction(HANASpatialFunctions.zmin.name(), (SQLFunction)new HANASpatialFunction(HANASpatialFunctions.zmin.getFunctionName(), (Type)StandardBasicTypes.DOUBLE, false));
    }

    @Override
    public String getSpatialRelateSQL(String columnName, int spatialRelation) {
        switch (spatialRelation) {
            case 4: {
                return columnName + ".ST_Within(ST_GeomFromEWKB(?)) = 1";
            }
            case 6: {
                return columnName + ".ST_Contains(ST_GeomFromEWKB(?)) = 1";
            }
            case 3: {
                return columnName + ".ST_Crosses(ST_GeomFromEWKB(?)) = 1";
            }
            case 5: {
                return columnName + ".ST_Overlaps(ST_GeomFromEWKB(?)) = 1";
            }
            case 1: {
                return columnName + ".ST_Disjoint(ST_GeomFromEWKB(?)) = 1";
            }
            case 7: {
                return columnName + ".ST_Intersects(ST_GeomFromEWKB(?)) = 1";
            }
            case 2: {
                return columnName + ".ST_Touches(ST_GeomFromEWKB(?)) = 1";
            }
            case 0: {
                return columnName + ".ST_Equals(ST_GeomFromEWKB(?)) = 1";
            }
            case 8: {
                return columnName + ".ST_IntersectsFilter(ST_GeomFromEWKB(?)) = 1";
            }
        }
        throw new IllegalArgumentException("Spatial relation is not known by this dialect");
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        ConfigurationService configurationService = (ConfigurationService)serviceRegistry.getService(ConfigurationService.class);
        boolean determineCrsIdFromDatabase = (Boolean)configurationService.getSetting(DETERMINE_CRS_ID_FROM_DATABASE_PARAMETER_NAME, (ConfigurationService.Converter)new ConfigurationService.Converter<Boolean>(){

            public Boolean convert(Object value) {
                return Boolean.valueOf(value.toString());
            }
        }, (Object)Boolean.FALSE);
        if (determineCrsIdFromDatabase) {
            typeContributions.contributeType((BasicType)new GeolatteGeometryType(HANAGeometryTypeDescriptor.CRS_LOADING_INSTANCE));
            typeContributions.contributeType((BasicType)new JTSGeometryType(HANAGeometryTypeDescriptor.CRS_LOADING_INSTANCE));
        } else {
            typeContributions.contributeType((BasicType)new GeolatteGeometryType(HANAGeometryTypeDescriptor.INSTANCE));
            typeContributions.contributeType((BasicType)new JTSGeometryType(HANAGeometryTypeDescriptor.INSTANCE));
        }
        typeContributions.contributeJavaTypeDescriptor((JavaTypeDescriptor)GeolatteGeometryJavaTypeDescriptor.INSTANCE);
        typeContributions.contributeJavaTypeDescriptor(JTSGeometryJavaTypeDescriptor.INSTANCE);
    }

    @Override
    public String getSpatialFilterExpression(String columnName) {
        return columnName + ".ST_IntersectsFilter(ST_GeomFromEWKB(?)) = 1";
    }

    @Override
    public String getSpatialAggregateSQL(String columnName, int aggregation) {
        switch (aggregation) {
            case 1: {
                return "ST_EnvelopeAggr(" + columnName + ")";
            }
        }
        throw new IllegalArgumentException("The aggregate type [" + aggregation + "] is not known by this dialect");
    }

    @Override
    public String getDWithinSQL(String columnName) {
        return columnName + ".ST_WithinDistance(ST_GeomFromEWKB(?), ?) = 1";
    }

    @Override
    public String getHavingSridSQL(String columnName) {
        return columnName + ".ST_SRID() = ?";
    }

    @Override
    public String getIsEmptySQL(String columnName, boolean isEmpty) {
        return columnName + ".ST_IsEmpty() = " + (isEmpty ? 1 : 0);
    }

    @Override
    public boolean supportsFiltering() {
        return true;
    }

    @Override
    public boolean supports(SpatialFunction function) {
        switch (function) {
            case asbinary: {
                return true;
            }
            case astext: {
                return true;
            }
            case boundary: {
                return true;
            }
            case buffer: {
                return true;
            }
            case contains: {
                return true;
            }
            case convexhull: {
                return true;
            }
            case crosses: {
                return true;
            }
            case difference: {
                return true;
            }
            case dimension: {
                return true;
            }
            case disjoint: {
                return true;
            }
            case distance: {
                return true;
            }
            case dwithin: {
                return true;
            }
            case envelope: {
                return true;
            }
            case equals: {
                return true;
            }
            case extent: {
                return true;
            }
            case geometrytype: {
                return true;
            }
            case geomunion: {
                return true;
            }
            case intersection: {
                return true;
            }
            case intersects: {
                return true;
            }
            case isempty: {
                return true;
            }
            case issimple: {
                return true;
            }
            case overlaps: {
                return true;
            }
            case relate: {
                return true;
            }
            case srid: {
                return true;
            }
            case symdifference: {
                return true;
            }
            case touches: {
                return true;
            }
            case transform: {
                return true;
            }
            case within: {
                return true;
            }
        }
        return false;
    }

    private static class FilterFunction
    extends HANASpatialFunction {
        public FilterFunction() {
            super("ST_IntersectsFilter", (Type)StandardBasicTypes.NUMERIC_BOOLEAN, true);
        }

        @Override
        public String render(Type firstArgumentType, List arguments, SessionFactoryImplementor sessionFactory) {
            return super.render(firstArgumentType, arguments, sessionFactory) + " = 1";
        }
    }
}

