/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.predicate;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.predicate.FilterPredicate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public final class SpatialPredicates {
    private SpatialPredicates() {
    }

    public static Predicate eq(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Expression<? extends Geometry> geometry2) {
        return SpatialPredicates.booleanExpressionToPredicate(criteriaBuilder, (Expression<Boolean>)criteriaBuilder.function(SpatialFunction.equals.toString(), Boolean.TYPE, new Expression[]{geometry1, geometry2}));
    }

    public static Predicate eq(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Geometry geometry2) {
        return SpatialPredicates.eq(criteriaBuilder, geometry1, (Expression<? extends Geometry>)criteriaBuilder.literal((Object)geometry2));
    }

    public static Predicate within(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Expression<? extends Geometry> geometry2) {
        return SpatialPredicates.booleanExpressionToPredicate(criteriaBuilder, (Expression<Boolean>)criteriaBuilder.function(SpatialFunction.within.toString(), Boolean.TYPE, new Expression[]{geometry1, geometry2}));
    }

    public static Predicate within(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Geometry geometry2) {
        return SpatialPredicates.within(criteriaBuilder, geometry1, (Expression<? extends Geometry>)criteriaBuilder.literal((Object)geometry2));
    }

    public static Predicate contains(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Expression<? extends Geometry> geometry2) {
        return SpatialPredicates.booleanExpressionToPredicate(criteriaBuilder, (Expression<Boolean>)criteriaBuilder.function(SpatialFunction.contains.toString(), Boolean.TYPE, new Expression[]{geometry1, geometry2}));
    }

    public static Predicate contains(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Geometry geometry2) {
        return SpatialPredicates.contains(criteriaBuilder, geometry1, (Expression<? extends Geometry>)criteriaBuilder.literal((Object)geometry2));
    }

    public static Predicate crosses(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Expression<? extends Geometry> geometry2) {
        return SpatialPredicates.booleanExpressionToPredicate(criteriaBuilder, (Expression<Boolean>)criteriaBuilder.function(SpatialFunction.crosses.toString(), Boolean.TYPE, new Expression[]{geometry1, geometry2}));
    }

    public static Predicate crosses(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Geometry geometry2) {
        return SpatialPredicates.crosses(criteriaBuilder, geometry1, (Expression<? extends Geometry>)criteriaBuilder.literal((Object)geometry2));
    }

    public static Predicate disjoint(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Expression<? extends Geometry> geometry2) {
        return SpatialPredicates.booleanExpressionToPredicate(criteriaBuilder, (Expression<Boolean>)criteriaBuilder.function(SpatialFunction.disjoint.toString(), Boolean.TYPE, new Expression[]{geometry1, geometry2}));
    }

    public static Predicate disjoint(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Geometry geometry2) {
        return SpatialPredicates.disjoint(criteriaBuilder, geometry1, (Expression<? extends Geometry>)criteriaBuilder.literal((Object)geometry2));
    }

    public static Predicate intersects(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Expression<? extends Geometry> geometry2) {
        return SpatialPredicates.booleanExpressionToPredicate(criteriaBuilder, (Expression<Boolean>)criteriaBuilder.function(SpatialFunction.intersects.toString(), Boolean.TYPE, new Expression[]{geometry1, geometry2}));
    }

    public static Predicate intersects(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Geometry geometry2) {
        return SpatialPredicates.intersects(criteriaBuilder, geometry1, (Expression<? extends Geometry>)criteriaBuilder.literal((Object)geometry2));
    }

    public static Predicate overlaps(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Expression<? extends Geometry> geometry2) {
        return SpatialPredicates.booleanExpressionToPredicate(criteriaBuilder, (Expression<Boolean>)criteriaBuilder.function(SpatialFunction.overlaps.toString(), Boolean.TYPE, new Expression[]{geometry1, geometry2}));
    }

    public static Predicate overlaps(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Geometry geometry2) {
        return SpatialPredicates.overlaps(criteriaBuilder, geometry1, (Expression<? extends Geometry>)criteriaBuilder.literal((Object)geometry2));
    }

    public static Predicate touches(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Expression<? extends Geometry> geometry2) {
        return SpatialPredicates.booleanExpressionToPredicate(criteriaBuilder, (Expression<Boolean>)criteriaBuilder.function(SpatialFunction.touches.toString(), Boolean.TYPE, new Expression[]{geometry1, geometry2}));
    }

    public static Predicate touches(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Geometry geometry2) {
        return SpatialPredicates.touches(criteriaBuilder, geometry1, (Expression<? extends Geometry>)criteriaBuilder.literal((Object)geometry2));
    }

    public static Predicate filter(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Expression<? extends Geometry> geometry2) {
        return new FilterPredicate(criteriaBuilder, geometry1, geometry2);
    }

    public static Predicate filter(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Geometry geometry2) {
        return new FilterPredicate(criteriaBuilder, geometry1, geometry2);
    }

    public static Predicate filterByPolygon(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry, Envelope envelope, int srid) {
        return new FilterPredicate(criteriaBuilder, geometry, envelope, srid);
    }

    public static Predicate distanceWithin(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Expression<? extends Geometry> geometry2, Expression<Double> distance) {
        return SpatialPredicates.booleanExpressionToPredicate(criteriaBuilder, (Expression<Boolean>)criteriaBuilder.function(SpatialFunction.dwithin.toString(), Boolean.TYPE, new Expression[]{geometry1, geometry2, distance}));
    }

    public static Predicate distanceWithin(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Geometry geometry2, Expression<Double> distance) {
        return SpatialPredicates.distanceWithin(criteriaBuilder, geometry1, (Expression<? extends Geometry>)criteriaBuilder.literal((Object)geometry2), distance);
    }

    public static Predicate distanceWithin(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Geometry geometry2, double distance) {
        return SpatialPredicates.distanceWithin(criteriaBuilder, geometry1, (Expression<? extends Geometry>)criteriaBuilder.literal((Object)geometry2), (Expression<Double>)criteriaBuilder.literal((Object)distance));
    }

    public static Predicate distanceWithin(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry1, Expression<? extends Geometry> geometry2, double distance) {
        return SpatialPredicates.distanceWithin(criteriaBuilder, geometry1, geometry2, (Expression<Double>)criteriaBuilder.literal((Object)distance));
    }

    public static Predicate havingSRID(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry, Expression<Integer> srid) {
        return criteriaBuilder.equal(criteriaBuilder.function(SpatialFunction.srid.toString(), Integer.TYPE, new Expression[]{geometry}), srid);
    }

    public static Predicate havingSRID(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry, int srid) {
        return SpatialPredicates.havingSRID(criteriaBuilder, geometry, (Expression<Integer>)criteriaBuilder.literal((Object)srid));
    }

    public static Predicate isEmpty(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry) {
        return SpatialPredicates.booleanExpressionToPredicate(criteriaBuilder, (Expression<Boolean>)criteriaBuilder.function(SpatialFunction.isempty.toString(), Boolean.TYPE, new Expression[]{geometry}));
    }

    public static Predicate isNotEmpty(CriteriaBuilder criteriaBuilder, Expression<? extends Geometry> geometry) {
        return SpatialPredicates.isEmpty(criteriaBuilder, geometry).not();
    }

    private static Predicate booleanExpressionToPredicate(CriteriaBuilder criteriaBuilder, Expression<Boolean> expression) {
        return criteriaBuilder.equal(expression, (Object)true);
    }
}

