/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.cache;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.GeneralDataRegion;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.testing.cache.BaseRegion;
import org.jboss.logging.Logger;

class BaseGeneralDataRegion
extends BaseRegion
implements GeneralDataRegion {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)BaseGeneralDataRegion.class.getName());

    BaseGeneralDataRegion(String name) {
        super(name);
    }

    public Object get(Object key) throws CacheException {
        LOG.debugf("Cache lookup : key[%s]", key);
        if (key == null) {
            return null;
        }
        Object result = this.cache.get(key);
        if (result != null) {
            LOG.debugf("Cache hit: %s", key);
        }
        return result;
    }

    public void put(Object key, Object value) throws CacheException {
        LOG.debugf("Caching : [%s] -> [%s]", key, value);
        if (key == null || value == null) {
            LOG.debug((Object)"Key or Value is null");
            return;
        }
        this.cache.put(key, value);
    }

    public void evict(Object key) throws CacheException {
        LOG.debugf("Invalidating: %s", key);
        if (key == null) {
            LOG.debug((Object)"Key is null");
            return;
        }
        this.cache.remove(key);
    }

    public void evictAll() throws CacheException {
        LOG.debug((Object)"evict cache");
        this.cache.clear();
    }
}

