/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.cache;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.internal.Timestamper;
import org.hibernate.cache.spi.Region;

class BaseRegion
implements Region {
    protected final Map cache = new ConcurrentHashMap();
    private final String name;
    private static int timeout = 245760000;

    BaseRegion(String name) {
        this.name = name;
    }

    public boolean contains(Object key) {
        return key != null ? this.cache.containsKey(key) : false;
    }

    public String getName() {
        return this.name;
    }

    public void destroy() throws CacheException {
        this.cache.clear();
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public long getElementCountInMemory() {
        return this.cache.size();
    }

    public long getElementCountOnDisk() {
        return 0L;
    }

    public Map toMap() {
        return Collections.unmodifiableMap(this.cache);
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public int getTimeout() {
        return timeout;
    }
}

