/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.junit4;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import org.hibernate.cfg.Configuration;
import org.hibernate.testing.FailureExpected;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public class Helper {
    public static final String VALIDATE_FAILURE_EXPECTED = "hibernate.test.validatefailureexpected";

    public static boolean isNotEmpty(String string) {
        return string != null && string.length() > 0;
    }

    public static String extractTestName(FrameworkMethod frameworkMethod) {
        return frameworkMethod.getMethod().getDeclaringClass().getName() + '#' + frameworkMethod.getName();
    }

    public static String extractMethodName(Method method) {
        return method.getDeclaringClass().getName() + "#" + method.getName();
    }

    public static <T extends Annotation> T locateAnnotation(Class<T> annotationClass, FrameworkMethod frameworkMethod, TestClass testClass) {
        Annotation annotation = frameworkMethod.getAnnotation(annotationClass);
        if (annotation == null) {
            annotation = testClass.getJavaClass().getAnnotation(annotationClass);
        }
        return (T)annotation;
    }

    public static String extractMessage(FailureExpected failureExpected) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('(').append(failureExpected.jiraKey()).append(')');
        if (Helper.isNotEmpty(failureExpected.message())) {
            buffer.append(" : ").append(failureExpected.message());
        }
        return buffer.toString();
    }

    public static String extractIgnoreMessage(FailureExpected failureExpected, FrameworkMethod frameworkMethod) {
        return "Ignoring test [" + Helper.extractTestName(frameworkMethod) + "] due to @FailureExpected - " + Helper.extractMessage(failureExpected);
    }

    public static void createH2Schema(String schemaName, Configuration cfg) {
        Helper.createH2Schema(schemaName, cfg.getProperties());
    }

    public static void createH2Schema(String schemaName, Map settings) {
        settings.put("hibernate.connection.url", settings.get("hibernate.connection.url") + ";INIT=CREATE SCHEMA IF NOT EXISTS " + schemaName);
    }
}

