/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.junit4;

import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class ClassLoadingIsolater
implements MethodRule {
    private final IsolatedClassLoaderProvider provider;

    public ClassLoadingIsolater(IsolatedClassLoaderProvider provider) {
        this.provider = provider;
    }

    public Statement apply(final Statement base, FrameworkMethod method, Object target) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                ClassLoader isolatedClassLoader = ClassLoadingIsolater.this.provider.buildIsolatedClassLoader();
                ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(isolatedClassLoader);
                try {
                    base.evaluate();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalTCCL);
                    ClassLoadingIsolater.this.provider.releaseIsolatedClassLoader(isolatedClassLoader);
                }
            }
        };
    }

    public static interface IsolatedClassLoaderProvider {
        public ClassLoader buildIsolatedClassLoader();

        public void releaseIsolatedClassLoader(ClassLoader var1);
    }
}

