/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.cache;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.testing.cache.BaseEntityRegionAccessStrategy;
import org.hibernate.testing.cache.EntityRegionImpl;
import org.jboss.logging.Logger;

class ReadOnlyEntityRegionAccessStrategy
extends BaseEntityRegionAccessStrategy {
    private static final Logger LOG = Logger.getLogger(ReadOnlyEntityRegionAccessStrategy.class);

    ReadOnlyEntityRegionAccessStrategy(EntityRegionImpl region) {
        super(region);
    }

    @Override
    public boolean insert(Object key, Object value, Object version) throws CacheException {
        return false;
    }

    @Override
    public boolean afterInsert(Object key, Object value, Object version) throws CacheException {
        this.getInternalRegion().put(key, value);
        return true;
    }

    @Override
    public void unlockItem(Object key, SoftLock lock) throws CacheException {
        this.evict(key);
    }

    @Override
    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        LOG.info((Object)("Illegal attempt to update item cached as read-only : " + key));
        throw new UnsupportedOperationException("Can't write to a readonly object");
    }

    @Override
    public boolean afterUpdate(Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        LOG.info((Object)("Illegal attempt to update item cached as read-only : " + key));
        throw new UnsupportedOperationException("Can't write to a readonly object");
    }
}

