/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.cache;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.testing.cache.BaseGeneralDataRegion;
import org.hibernate.testing.cache.BaseRegionAccessStrategy;
import org.hibernate.testing.cache.EntityRegionImpl;

class BaseEntityRegionAccessStrategy
extends BaseRegionAccessStrategy
implements EntityRegionAccessStrategy {
    private final EntityRegionImpl region;

    BaseEntityRegionAccessStrategy(EntityRegionImpl region) {
        this.region = region;
    }

    public EntityRegion getRegion() {
        return this.region;
    }

    public boolean insert(SessionImplementor session, Object key, Object value, Object version) throws CacheException {
        return this.putFromLoad(session, key, value, 0L, version);
    }

    public boolean afterInsert(SessionImplementor session, Object key, Object value, Object version) throws CacheException {
        return true;
    }

    public boolean update(SessionImplementor session, Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        return false;
    }

    public boolean afterUpdate(SessionImplementor session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        return false;
    }

    @Override
    protected BaseGeneralDataRegion getInternalRegion() {
        return this.region;
    }

    @Override
    protected boolean isDefaultMinimalPutOverride() {
        return this.region.getSettings().isMinimalPutsEnabled();
    }

    public Object generateCacheKey(Object id, EntityPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return this.region.getRegionFactory().getCacheKeysFactory().createEntityKey(id, persister, factory, tenantIdentifier);
    }

    public Object getCacheKeyId(Object cacheKey) {
        return this.region.getRegionFactory().getCacheKeysFactory().getEntityId(cacheKey);
    }
}

