/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing;

import org.hibernate.dialect.Dialect;
import org.hibernate.testing.DialectCheck;

public abstract class DialectChecks {

    public static class SupportCatalogCreation
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.canCreateCatalog();
        }
    }

    public static class SupportSchemaCreation
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.canCreateSchema();
        }
    }

    public static class DoubleQuoteQuoting
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return '\"' == dialect.openQuote() && '\"' == dialect.closeQuote();
        }
    }

    public static class SupportsLockTimeouts
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsLockTimeouts();
        }
    }

    public static class SupportsLobValueChangePropogation
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsLobValueChangePropogation();
        }
    }

    public static class SupportsExistsInSelectCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsExistsInSelect();
        }
    }

    public static class DoesRepeatableReadNotCauseReadersToBlockWritersCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return !dialect.doesRepeatableReadCauseReadersToBlockWriters();
        }
    }

    public static class DoesRepeatableReadCauseReadersToBlockWritersCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.doesRepeatableReadCauseReadersToBlockWriters();
        }
    }

    public static class DoesReadCommittedNotCauseWritersToBlockReadersCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return !dialect.doesReadCommittedCauseWritersToBlockReaders();
        }
    }

    public static class DoesReadCommittedCauseWritersToBlockReadersCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.doesReadCommittedCauseWritersToBlockReaders();
        }
    }

    public static class SupportsRowValueConstructorSyntaxInInListCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsRowValueConstructorSyntaxInInList();
        }
    }

    public static class HasSelfReferentialForeignKeyBugCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.hasSelfReferentialForeignKeyBug();
        }
    }

    public static class SupportsParametersInInsertSelectCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsParametersInInsertSelect();
        }
    }

    public static class SupportLimitAndOffsetCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsLimit() && dialect.supportsLimitOffset();
        }
    }

    public static class SupportLimitCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsLimit();
        }
    }

    public static class SupportSubqueryAsLeftHandSideInPredicate
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsSubselectAsInPredicateLHS();
        }
    }

    public static class SupportsUnboundedLobLocatorMaterializationCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsExpectedLobUsagePattern() && dialect.supportsUnboundedLobLocatorMaterialization();
        }
    }

    public static class SupportsCircularCascadeDeleteCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsCircularCascadeDeleteConstraints();
        }
    }

    public static class SupportsCascadeDeleteCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsCascadeDelete();
        }
    }

    public static class SupportsResultSetPositioningOnForwardOnlyCursorCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsResultSetPositionQueryMethodsOnForwardOnlyCursor();
        }
    }

    public static class CaseSensitiveCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.areStringComparisonsCaseInsensitive();
        }
    }

    public static class SupportsEmptyInListCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsEmptyInList();
        }
    }

    public static class SupportsColumnCheck
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsColumnCheck();
        }
    }

    public static class SupportsIdentityColumns
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsIdentityColumns();
        }
    }

    public static class UsesInputStreamToInsertBlob
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.useInputStreamToInsertBlob();
        }
    }

    public static class SupportsExpectedLobUsagePattern
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsExpectedLobUsagePattern();
        }
    }

    public static class SupportsSequences
    implements DialectCheck {
        @Override
        public boolean isMatch(Dialect dialect) {
            return dialect.supportsSequences();
        }
    }
}

