/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.cache;

import java.util.Comparator;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.testing.cache.AbstractReadWriteAccessStrategy;
import org.hibernate.testing.cache.BaseGeneralDataRegion;
import org.hibernate.testing.cache.NaturalIdRegionImpl;

class ReadWriteNaturalIdRegionAccessStrategy
extends AbstractReadWriteAccessStrategy
implements NaturalIdRegionAccessStrategy {
    private final NaturalIdRegionImpl region;

    ReadWriteNaturalIdRegionAccessStrategy(NaturalIdRegionImpl region) {
        this.region = region;
    }

    public boolean insert(SessionImplementor session, Object key, Object value) throws CacheException {
        return false;
    }

    public boolean update(SessionImplementor session, Object key, Object value) throws CacheException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean afterInsert(SessionImplementor session, Object key, Object value) throws CacheException {
        try {
            this.writeLock.lock();
            AbstractReadWriteAccessStrategy.Lockable item = (AbstractReadWriteAccessStrategy.Lockable)this.region.get(session, key);
            if (item == null) {
                this.region.put(session, key, new AbstractReadWriteAccessStrategy.Item(value, null, this.region.nextTimestamp()));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean afterUpdate(SessionImplementor session, Object key, Object value, SoftLock lock) throws CacheException {
        try {
            this.writeLock.lock();
            AbstractReadWriteAccessStrategy.Lockable item = (AbstractReadWriteAccessStrategy.Lockable)this.region.get(session, key);
            if (item != null && item.isUnlockable(lock)) {
                AbstractReadWriteAccessStrategy.Lock lockItem = (AbstractReadWriteAccessStrategy.Lock)item;
                if (lockItem.wasLockedConcurrently()) {
                    this.decrementLock(session, key, lockItem);
                    boolean bl = false;
                    return bl;
                }
                this.region.put(session, key, new AbstractReadWriteAccessStrategy.Item(value, null, this.region.nextTimestamp()));
                boolean bl = true;
                return bl;
            }
            this.handleLockExpiry(session, key, item);
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    Comparator getVersionComparator() {
        return this.region.getCacheDataDescription().getVersionComparator();
    }

    @Override
    protected BaseGeneralDataRegion getInternalRegion() {
        return this.region;
    }

    @Override
    protected boolean isDefaultMinimalPutOverride() {
        return this.region.getSettings().isMinimalPutsEnabled();
    }

    public NaturalIdRegion getRegion() {
        return this.region;
    }

    public Object generateCacheKey(Object[] naturalIdValues, EntityPersister persister, SessionImplementor session) {
        return DefaultCacheKeysFactory.createNaturalIdKey((Object[])naturalIdValues, (EntityPersister)persister, (SessionImplementor)session);
    }

    public Object[] getNaturalIdValues(Object cacheKey) {
        return DefaultCacheKeysFactory.getNaturalIdValues((Object)cacheKey);
    }
}

