/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.cache;

import java.util.Properties;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.testing.cache.BaseGeneralDataRegion;
import org.hibernate.testing.cache.CollectionRegionImpl;
import org.hibernate.testing.cache.EntityRegionImpl;
import org.hibernate.testing.cache.NaturalIdRegionImpl;
import org.hibernate.testing.cache.Timestamper;
import org.jboss.logging.Logger;

public class CachingRegionFactory
implements RegionFactory {
    private static final Logger LOG = Logger.getLogger((String)CachingRegionFactory.class.getName());
    public static String DEFAULT_ACCESSTYPE = "DefaultAccessType";
    private final CacheKeysFactory cacheKeysFactory;
    private SessionFactoryOptions settings;
    private Properties properties;

    public CachingRegionFactory() {
        this(DefaultCacheKeysFactory.INSTANCE, null);
    }

    public CachingRegionFactory(CacheKeysFactory cacheKeysFactory) {
        this(cacheKeysFactory, null);
    }

    public CachingRegionFactory(Properties properties) {
        this(DefaultCacheKeysFactory.INSTANCE, properties);
    }

    public CachingRegionFactory(CacheKeysFactory cacheKeysFactory, Properties properties) {
        LOG.warn((Object)"CachingRegionFactory should be only used for testing.");
        this.cacheKeysFactory = cacheKeysFactory;
        this.properties = properties;
    }

    public CacheKeysFactory getCacheKeysFactory() {
        return this.cacheKeysFactory;
    }

    public void start(SessionFactoryOptions settings, Properties properties) throws CacheException {
        this.settings = settings;
        this.properties = properties;
    }

    public void stop() {
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return false;
    }

    public AccessType getDefaultAccessType() {
        if (this.properties != null && this.properties.get(DEFAULT_ACCESSTYPE) != null) {
            return AccessType.fromExternalName((String)this.properties.getProperty(DEFAULT_ACCESSTYPE));
        }
        return AccessType.READ_WRITE;
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public EntityRegion buildEntityRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new EntityRegionImpl(this, regionName, metadata, this.settings);
    }

    public NaturalIdRegion buildNaturalIdRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new NaturalIdRegionImpl(this, regionName, metadata, this.settings);
    }

    public CollectionRegion buildCollectionRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new CollectionRegionImpl(this, regionName, metadata, this.settings);
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) throws CacheException {
        return new QueryResultsRegionImpl(this, regionName);
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, Properties properties) throws CacheException {
        return new TimestampsRegionImpl(this, regionName);
    }

    private static class TimestampsRegionImpl
    extends BaseGeneralDataRegion
    implements TimestampsRegion {
        TimestampsRegionImpl(CachingRegionFactory cachingRegionFactory, String name) {
            super(cachingRegionFactory, name);
        }
    }

    private static class QueryResultsRegionImpl
    extends BaseGeneralDataRegion
    implements QueryResultsRegion {
        QueryResultsRegionImpl(CachingRegionFactory cachingRegionFactory, String name) {
            super(cachingRegionFactory, name);
        }
    }
}

