/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.transaction;

import java.util.function.Consumer;
import org.hibernate.Transaction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.jboss.logging.Logger;

public class TransactionUtil2 {
    private static final Logger log = Logger.getLogger(TransactionUtil2.class);
    public static final String ACTION_COMPLETED_TXN = "Execution of action caused managed transaction to be completed";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void inSession(SessionFactoryImplementor sfi, Consumer<SessionImplementor> action) {
        log.trace((Object)"#inSession(SF,action)");
        try (SessionImplementor session = (SessionImplementor)sfi.openSession();){
            log.trace((Object)"Session opened, calling action");
            action.accept(session);
            log.trace((Object)"called action");
        }
        finally {
            log.trace((Object)"Session closed (AutoCloseable)");
        }
    }

    public static void inTransaction(SessionFactoryImplementor factory, Consumer<SessionImplementor> action) {
        log.trace((Object)"#inTransaction(factory, action)");
        TransactionUtil2.inSession(factory, session -> TransactionUtil2.inTransaction(session, action));
    }

    public static void inTransaction(SessionImplementor session, Consumer<SessionImplementor> action) {
        log.trace((Object)"inTransaction(session,action)");
        Transaction txn = session.beginTransaction();
        log.trace((Object)"Started transaction");
        try {
            log.trace((Object)"Calling action in txn");
            action.accept(session);
            log.trace((Object)"Called action - in txn");
            if (!txn.isActive()) {
                throw new TransactionManagementException(ACTION_COMPLETED_TXN);
            }
        }
        catch (Exception e) {
            if (!txn.isActive()) {
                log.warn((Object)ACTION_COMPLETED_TXN, (Throwable)e);
            } else {
                log.trace((Object)"Rolling back transaction due to action error");
                try {
                    txn.rollback();
                    log.trace((Object)"Rolled back transaction due to action error");
                }
                catch (Exception inner) {
                    log.trace((Object)"Rolling back transaction due to action error failed; throwing original error");
                }
            }
            throw e;
        }
        log.trace((Object)"Committing transaction after successful action execution");
        try {
            txn.commit();
            log.trace((Object)"Committing transaction after successful action execution - success");
        }
        catch (Exception e) {
            log.trace((Object)"Committing transaction after successful action execution - failure");
            throw e;
        }
    }

    private static class TransactionManagementException
    extends RuntimeException {
        public TransactionManagementException(String message) {
            super(message);
        }
    }
}

