/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class TestingUtil {
    private TestingUtil() {
    }

    public static <A extends Annotation> Optional<A> findEffectiveAnnotation(ExtensionContext context, Class<A> annotationType) {
        if (!context.getElement().isPresent()) {
            return Optional.empty();
        }
        AnnotatedElement annotatedElement = (AnnotatedElement)context.getElement().get();
        Optional direct = AnnotationSupport.findAnnotation((AnnotatedElement)annotatedElement, annotationType);
        if (direct.isPresent()) {
            return direct;
        }
        if (context.getTestInstance().isPresent()) {
            return AnnotationSupport.findAnnotation(context.getRequiredTestInstance().getClass(), annotationType);
        }
        return Optional.empty();
    }

    public static <A extends Annotation> List<A> findEffectiveRepeatingAnnotation(ExtensionContext context, Class<A> annotationType, Class<? extends Annotation> groupAnnotationType) {
        if (!context.getElement().isPresent()) {
            return Collections.emptyList();
        }
        Optional<A> effectiveAnnotation = TestingUtil.findEffectiveAnnotation(context, annotationType);
        Optional<? extends Annotation> effectiveGroupingAnnotation = TestingUtil.findEffectiveAnnotation(context, groupAnnotationType);
        if (effectiveAnnotation.isPresent() || effectiveGroupingAnnotation.isPresent()) {
            if (!effectiveGroupingAnnotation.isPresent()) {
                return Collections.singletonList(effectiveAnnotation.get());
            }
            ArrayList list = new ArrayList();
            effectiveAnnotation.ifPresent(list::add);
            try {
                Method valueMethod = groupAnnotationType.getDeclaredMethod("value", null);
                Collections.addAll(list, (Annotation[])valueMethod.invoke((Object)effectiveGroupingAnnotation.get(), new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException("Could not locate repeated/grouped annotations", e);
            }
            return list;
        }
        return Collections.emptyList();
    }

    public static <A extends Annotation> boolean hasEffectiveAnnotation(ExtensionContext context, Class<A> annotationType) {
        return TestingUtil.findEffectiveAnnotation(context, annotationType).isPresent();
    }

    public static <T> T cast(Object thing, Class<T> type) {
        MatcherAssert.assertThat((Object)thing, (Matcher)CoreMatchers.instanceOf(type));
        return type.cast(thing);
    }
}

