/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.tool.hbm2x.ExporterException;
import org.hibernate.tool.hbm2x.XMLPrettyPrinter;

public class ArtifactCollector {
    protected final Map files = new HashMap();

    public void addFile(File file, String type) {
        ArrayList<File> existing = (ArrayList<File>)this.files.get(type);
        if (existing == null) {
            existing = new ArrayList<File>();
            this.files.put(type, existing);
        }
        existing.add(file);
    }

    public int getFileCount(String type) {
        List existing = (List)this.files.get(type);
        return existing == null ? 0 : existing.size();
    }

    public File[] getFiles(String type) {
        List existing = (List)this.files.get(type);
        if (existing == null) {
            return new File[0];
        }
        return existing.toArray(new File[existing.size()]);
    }

    public Set getFileTypes() {
        return this.files.keySet();
    }

    public void formatFiles() {
        this.formatXml("xml");
        this.formatXml("hbm.xml");
        this.formatXml("cfg.xml");
    }

    private void formatXml(String type) throws ExporterException {
        List list = (List)this.files.get(type);
        if (list != null && !list.isEmpty()) {
            for (File xmlFile : list) {
                try {
                    XMLPrettyPrinter.prettyPrintFile(XMLPrettyPrinter.getDefaultTidy(), xmlFile, xmlFile, true);
                }
                catch (IOException e) {
                    throw new ExporterException("Could not format XML file: " + xmlFile, e);
                }
            }
        }
    }
}

