/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.JDBCException;
import org.hibernate.MappingException;
import org.hibernate.cfg.JDBCBinderException;
import org.hibernate.cfg.reveng.DatabaseCollector;
import org.hibernate.cfg.reveng.JDBCToHibernateTypeHelper;
import org.hibernate.cfg.reveng.ProgressListener;
import org.hibernate.cfg.reveng.ReverseEngineeringRuntimeInfo;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.SchemaSelection;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.cfg.reveng.dialect.MetaDataDialect;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.exception.spi.SQLExceptionConverter;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.sql.Alias;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCReader {
    private static final Logger log = LoggerFactory.getLogger(JDBCReader.class);
    private final ReverseEngineeringStrategy revengStrategy;
    private MetaDataDialect metadataDialect;
    private final ConnectionProvider provider;
    private final SQLExceptionConverter sec;
    private final String defaultSchema;
    private final String defaultCatalog;

    public JDBCReader(MetaDataDialect dialect, ConnectionProvider provider, SQLExceptionConverter sec, String defaultCatalog, String defaultSchema, ReverseEngineeringStrategy reveng) {
        this.metadataDialect = dialect;
        this.provider = provider;
        this.sec = sec;
        this.revengStrategy = reveng;
        this.defaultCatalog = defaultCatalog;
        this.defaultSchema = defaultSchema;
        if (this.revengStrategy == null) {
            throw new IllegalStateException("Strategy cannot be null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List readDatabaseSchema(DatabaseCollector dbs, String catalog, String schema, ProgressListener progress) {
        try {
            ReverseEngineeringRuntimeInfo info = new ReverseEngineeringRuntimeInfo(this.provider, this.sec, dbs);
            this.getMetaDataDialect().configure(info);
            this.revengStrategy.configure(info);
            HashSet hasIndices = new HashSet();
            List schemaSelectors = this.revengStrategy.getSchemaSelections();
            ArrayList foundTables = new ArrayList();
            if (schemaSelectors == null) {
                foundTables.addAll(this.processTables(dbs, new SchemaSelection(catalog, schema), hasIndices, progress));
            } else {
                for (SchemaSelection selection : schemaSelectors) {
                    foundTables.addAll(this.processTables(dbs, selection, hasIndices, progress));
                }
            }
            for (Table table : foundTables) {
                this.processBasicColumns(table, progress);
                this.processPrimaryKey(dbs, table);
                if (!hasIndices.contains(table)) continue;
                this.processIndices(table);
            }
            Iterator tables = foundTables.iterator();
            Map oneToManyCandidates = this.resolveForeignKeys(dbs, tables, progress);
            dbs.setOneToManyCandidates(oneToManyCandidates);
            ArrayList arrayList = foundTables;
            return arrayList;
        }
        finally {
            this.getMetaDataDialect().close();
            this.revengStrategy.close();
        }
    }

    private Map resolveForeignKeys(DatabaseCollector dbs, Iterator tables, ProgressListener progress) {
        ArrayList<ForeignKeysInfo> fks = new ArrayList<ForeignKeysInfo>();
        while (tables.hasNext()) {
            Table table = (Table)tables.next();
            ForeignKeysInfo foreignKeys = this.processForeignKeys(dbs, table, progress);
            fks.add(foreignKeys);
        }
        HashMap oneToManyCandidates = new HashMap();
        for (ForeignKeysInfo element : fks) {
            Map map = element.process(this.revengStrategy);
            this.mergeMultiMap(oneToManyCandidates, map);
        }
        return oneToManyCandidates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ForeignKeysInfo processForeignKeys(DatabaseCollector dbs, Table referencedTable, ProgressListener progress) throws JDBCBinderException {
        HashMap dependentColumns = new HashMap();
        HashMap<String, Table> dependentTables = new HashMap<String, Table>();
        HashMap referencedColumns = new HashMap();
        short bogusFkName = 0;
        Iterator exportedKeyIterator = null;
        log.debug("Calling getExportedKeys on " + referencedTable);
        progress.startSubTask("Finding exported foreignkeys on " + referencedTable.getName());
        try {
            Map exportedKeyRs = null;
            exportedKeyIterator = this.getMetaDataDialect().getExportedKeys(this.getCatalogForDBLookup(referencedTable.getCatalog()), this.getSchemaForDBLookup(referencedTable.getSchema()), referencedTable.getName());
            try {
                while (exportedKeyIterator.hasNext()) {
                    Column refColumn;
                    ArrayList<Column> depColumns;
                    exportedKeyRs = (Map)exportedKeyIterator.next();
                    String fkCatalog = this.getCatalogForModel((String)exportedKeyRs.get("FKTABLE_CAT"));
                    String fkSchema = this.getSchemaForModel((String)exportedKeyRs.get("FKTABLE_SCHEM"));
                    String fkTableName = (String)exportedKeyRs.get("FKTABLE_NAME");
                    String fkColumnName = (String)exportedKeyRs.get("FKCOLUMN_NAME");
                    String pkColumnName = (String)exportedKeyRs.get("PKCOLUMN_NAME");
                    String fkName = (String)exportedKeyRs.get("FK_NAME");
                    short keySeq = (Short)exportedKeyRs.get("KEY_SEQ");
                    Table fkTable = dbs.getTable(fkSchema, fkCatalog, fkTableName);
                    if (fkTable == null) {
                        log.debug("Foreign key " + fkName + " references unknown or filtered table " + Table.qualify((String)fkCatalog, (String)fkSchema, (String)fkTableName));
                        continue;
                    }
                    log.debug("Foreign key " + fkName);
                    if (keySeq == 0) {
                        bogusFkName = (short)(bogusFkName + 1);
                    }
                    if (fkName == null) {
                        fkName = Short.toString(bogusFkName);
                    }
                    if ((depColumns = (ArrayList<Column>)dependentColumns.get(fkName)) == null) {
                        depColumns = new ArrayList<Column>();
                        dependentColumns.put(fkName, depColumns);
                        dependentTables.put(fkName, fkTable);
                    } else {
                        Object previousTable = dependentTables.get(fkName);
                        if (fkTable != previousTable) {
                            throw new JDBCBinderException("Foreign key name (" + fkName + ") mapped to different tables! previous: " + previousTable + " current:" + fkTable);
                        }
                    }
                    Column column = new Column(fkColumnName);
                    Column existingColumn = fkTable.getColumn(column);
                    column = existingColumn == null ? column : existingColumn;
                    depColumns.add(column);
                    ArrayList<Column> primColumns = (ArrayList<Column>)referencedColumns.get(fkName);
                    if (primColumns == null) {
                        primColumns = new ArrayList<Column>();
                        referencedColumns.put(fkName, primColumns);
                    }
                    refColumn = (existingColumn = referencedTable.getColumn(refColumn = new Column(pkColumnName))) == null ? refColumn : existingColumn;
                    primColumns.add(refColumn);
                }
            }
            finally {
                try {
                    if (exportedKeyIterator != null) {
                        this.getMetaDataDialect().close(exportedKeyIterator);
                    }
                }
                catch (JDBCException se) {
                    log.warn("Exception while closing result set for foreign key meta data", (Throwable)se);
                }
            }
        }
        catch (JDBCException se) {
            log.warn("Exception while reading foreign keys for " + referencedTable + " [" + se.toString() + "]", (Throwable)se);
        }
        List userForeignKeys = this.revengStrategy.getForeignKeys(TableIdentifier.create(referencedTable));
        if (userForeignKeys != null) {
            for (ForeignKey element : userForeignKeys) {
                if (!this.equalTable(referencedTable, element.getReferencedTable())) {
                    log.debug("Referenced table " + element.getReferencedTable().getName() + " is not " + referencedTable + ". Ignoring userdefined foreign key " + element);
                    continue;
                }
                String userfkName = element.getName();
                Table userfkTable = element.getTable();
                List userColumns = element.getColumns();
                List userrefColumns = element.getReferencedColumns();
                Table deptable = (Table)dependentTables.get(userfkName);
                if (deptable != null) {
                    throw new MappingException("Foreign key " + userfkName + " already defined in the database!");
                }
                deptable = dbs.getTable(userfkTable.getSchema(), userfkTable.getCatalog(), userfkTable.getName());
                if (deptable == null) {
                    log.debug("User defined foreign key " + userfkName + " references unknown or filtered table " + TableIdentifier.create(userfkTable));
                    continue;
                }
                dependentTables.put(userfkName, deptable);
                ArrayList<Column> depColumns = new ArrayList<Column>(userColumns.size());
                for (Column jdbcColumn : userColumns) {
                    Column column = new Column(jdbcColumn.getName());
                    Column existingColumn = deptable.getColumn(column);
                    column = existingColumn == null ? column : existingColumn;
                    depColumns.add(column);
                }
                ArrayList<Column> refColumns = new ArrayList<Column>(userrefColumns.size());
                for (Column jdbcColumn : userrefColumns) {
                    Column column = new Column(jdbcColumn.getName());
                    Column existingColumn = referencedTable.getColumn(column);
                    column = existingColumn == null ? column : existingColumn;
                    refColumns.add(column);
                }
                referencedColumns.put(userfkName, refColumns);
                dependentColumns.put(userfkName, depColumns);
            }
        }
        return new ForeignKeysInfo(referencedTable, dependentTables, dependentColumns, referencedColumns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processPrimaryKey(DatabaseCollector dbs, Table table) {
        PrimaryKey key;
        ArrayList<Object[]> columns;
        block27: {
            columns = new ArrayList<Object[]>();
            key = null;
            Iterator primaryKeyIterator = null;
            try {
                Map primaryKeyRs = null;
                primaryKeyIterator = this.getMetaDataDialect().getPrimaryKeys(this.getCatalogForDBLookup(table.getCatalog()), this.getSchemaForDBLookup(table.getSchema()), table.getName());
                while (primaryKeyIterator.hasNext()) {
                    primaryKeyRs = (Map)primaryKeyIterator.next();
                    String columnName = (String)primaryKeyRs.get("COLUMN_NAME");
                    short seq = (Short)primaryKeyRs.get("KEY_SEQ");
                    String string = (String)primaryKeyRs.get("PK_NAME");
                    if (key == null) {
                        key = new PrimaryKey();
                        key.setName(string);
                        key.setTable(table);
                        if (table.getPrimaryKey() != null) {
                            throw new JDBCBinderException(table + " already has a primary key!");
                        }
                        table.setPrimaryKey(key);
                    } else if (string != key.getName() && string != null && !string.equals(key.getName())) {
                        throw new JDBCBinderException("Duplicate names found for primarykey. Existing name: " + key.getName() + " JDBC name: " + string + " on table " + table);
                    }
                    columns.add(new Object[]{new Short(seq), columnName});
                }
                if (primaryKeyIterator == null) break block27;
            }
            catch (Throwable throwable) {
                if (primaryKeyIterator == null) throw throwable;
                try {
                    this.getMetaDataDialect().close(primaryKeyIterator);
                    throw throwable;
                }
                catch (JDBCException se) {
                    log.warn("Exception when closing resultset for reading primary key information", (Throwable)se);
                }
                throw throwable;
            }
            try {
                this.getMetaDataDialect().close(primaryKeyIterator);
            }
            catch (JDBCException se) {
                log.warn("Exception when closing resultset for reading primary key information", (Throwable)se);
            }
        }
        Collections.sort(columns, new Comparator(){

            @Override
            public boolean equals(Object obj) {
                return super.equals(obj);
            }

            public int compare(Object o1, Object o2) {
                Short left = (Short)((Object[])o1)[0];
                Short right = (Short)((Object[])o2)[0];
                return left.compareTo(right);
            }

            public int hashCode() {
                return super.hashCode();
            }
        });
        ArrayList<Object> t = new ArrayList<Object>(columns.size());
        for (Object[] element : columns) {
            t.add(element[1]);
        }
        columns = t;
        if (key == null) {
            log.warn("The JDBC driver didn't report any primary key columns in " + table.getName() + ". Asking rev.eng. strategy");
            List userPrimaryKey = this.revengStrategy.getPrimaryKeyColumnNames(TableIdentifier.create(table));
            if (userPrimaryKey != null && !userPrimaryKey.isEmpty()) {
                key = new PrimaryKey();
                key.setName(new Alias(15, "PK").toAliasString(table.getName()));
                key.setTable(table);
                if (table.getPrimaryKey() != null) {
                    throw new JDBCBinderException(table + " already has a primary key!");
                }
                table.setPrimaryKey(key);
                columns = new ArrayList(userPrimaryKey);
            } else {
                log.warn("Rev.eng. strategy did not report any primary key columns for " + table.getName());
            }
        }
        Iterator suggestedPrimaryKeyStrategyName = this.getMetaDataDialect().getSuggestedPrimaryKeyStrategyName(this.getCatalogForDBLookup(table.getCatalog()), this.getSchemaForDBLookup(table.getSchema()), table.getName());
        try {
            Map map;
            String suggestion;
            if (suggestedPrimaryKeyStrategyName.hasNext() && (suggestion = (String)(map = (Map)suggestedPrimaryKeyStrategyName.next()).get("HIBERNATE_STRATEGY")) != null) {
                dbs.addSuggestedIdentifierStrategy(table.getCatalog(), table.getSchema(), table.getName(), suggestion);
            }
        }
        finally {
            if (suggestedPrimaryKeyStrategyName != null) {
                try {
                    this.getMetaDataDialect().close(suggestedPrimaryKeyStrategyName);
                }
                catch (JDBCException jDBCException) {
                    log.warn("Exception while closing iterator for suggested primary key strategy name", (Throwable)jDBCException);
                }
            }
        }
        if (key == null) return;
        Iterator cols = columns.iterator();
        while (true) {
            if (!cols.hasNext()) {
                log.debug("primary key for " + table + " -> " + key);
                return;
            }
            String string = (String)cols.next();
            Column col = this.getColumn(table, string);
            key.addColumn(col);
        }
    }

    private boolean safeEquals(Object value, Object tf) {
        if (value == tf) {
            return true;
        }
        if (value == null) {
            return false;
        }
        return value.equals(tf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection processTables(DatabaseCollector dbs, SchemaSelection schemaSelection, Set hasIndices, ProgressListener progress) {
        Object var5_5 = null;
        Iterator tableIterator = null;
        ArrayList tables = new ArrayList();
        boolean multiSchema = false;
        try {
            progress.startSubTask("Finding tables in " + schemaSelection);
            tableIterator = this.getMetaDataDialect().getTables(StringHelper.replace((String)schemaSelection.getMatchCatalog(), (String)".*", (String)"%"), StringHelper.replace((String)schemaSelection.getMatchSchema(), (String)".*", (String)"%"), StringHelper.replace((String)schemaSelection.getMatchTable(), (String)".*", (String)"%"));
            String[] lastQualifier = null;
            String[] foundQualifier = new String[2];
            while (tableIterator.hasNext()) {
                Map map = (Map)tableIterator.next();
                String tableName = (String)map.get("TABLE_NAME");
                String schemaName = (String)map.get("TABLE_SCHEM");
                String catalogName = (String)map.get("TABLE_CAT");
                TableIdentifier ti = new TableIdentifier(catalogName, schemaName, tableName);
                if (this.revengStrategy.excludeTable(ti)) {
                    log.debug("Table " + ti + " excluded by strategy");
                    continue;
                }
                if (!multiSchema) {
                    foundQualifier[0] = catalogName;
                    foundQualifier[1] = schemaName;
                    if (lastQualifier == null) {
                        lastQualifier = new String[]{foundQualifier[0], foundQualifier[1]};
                    }
                    if (!this.safeEquals(lastQualifier[0], foundQualifier[0]) || !this.safeEquals(lastQualifier[1], foundQualifier[1])) {
                        multiSchema = true;
                    }
                }
                tables.add(new HashMap(map));
            }
        }
        catch (Throwable throwable) {
            try {
                if (tableIterator != null) {
                    this.getMetaDataDialect().close(tableIterator);
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (tableIterator != null) {
                this.getMetaDataDialect().close(tableIterator);
            }
        }
        catch (Exception ignore) {}
        ArrayList<Table> processedTables = new ArrayList<Table>();
        for (Map map : tables) {
            String tableName = (String)map.get("TABLE_NAME");
            String schemaName = (String)map.get("TABLE_SCHEM");
            String catalogName = (String)map.get("TABLE_CAT");
            String comment = (String)map.get("REMARKS");
            String tableType = (String)map.get("TABLE_TYPE");
            if (dbs.getTable(schemaName, catalogName, tableName) != null) {
                log.debug("Ignoring " + tableName + " since it has already been processed");
                continue;
            }
            if ("TABLE".equalsIgnoreCase(tableType) || "VIEW".equalsIgnoreCase(tableType)) {
                if (schemaName != null && schemaName.trim().length() == 0) {
                    schemaName = null;
                }
                if (catalogName != null && catalogName.trim().length() == 0) {
                    catalogName = null;
                }
                log.debug("Adding table " + tableName + " of type " + tableType);
                progress.startSubTask("Found " + tableName);
                Table table = dbs.addTable(this.getSchemaForModel(schemaName), this.getCatalogForModel(catalogName), tableName);
                table.setComment(comment);
                if (tableType.equalsIgnoreCase("TABLE")) {
                    hasIndices.add(table);
                }
                processedTables.add(table);
                continue;
            }
            log.debug("Ignoring table " + tableName + " of type " + tableType);
        }
        return processedTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processBasicColumns(Table table, ProgressListener progress) {
        String qualify = Table.qualify((String)table.getCatalog(), (String)table.getSchema(), (String)table.getName());
        Iterator columnIterator = null;
        try {
            Map columnRs = null;
            log.debug("Finding columns for " + qualify);
            progress.startSubTask("Finding columns for " + qualify);
            columnIterator = this.getMetaDataDialect().getColumns(this.getCatalogForDBLookup(table.getCatalog()), this.getSchemaForDBLookup(table.getSchema()), table.getName(), null);
            while (columnIterator.hasNext()) {
                columnRs = (Map)columnIterator.next();
                String tableName = (String)columnRs.get("TABLE_NAME");
                int sqlType = (Integer)columnRs.get("DATA_TYPE");
                String columnName = (String)columnRs.get("COLUMN_NAME");
                String comment = (String)columnRs.get("REMARKS");
                TableIdentifier ti = TableIdentifier.create(table);
                if (this.revengStrategy.excludeColumn(ti, columnName)) {
                    log.debug("Column " + ti + "." + columnName + " excluded by strategy");
                    continue;
                }
                if (!tableName.equals(table.getName())) {
                    log.debug("Table name " + tableName + " does not match requested " + table.getName() + ". Ignoring column " + columnName + " since it either is invalid or a duplicate");
                    continue;
                }
                int dbNullability = (Integer)columnRs.get("NULLABLE");
                boolean isNullable = true;
                switch (dbNullability) {
                    case 1: 
                    case 2: {
                        isNullable = true;
                        break;
                    }
                    case 0: {
                        isNullable = false;
                        break;
                    }
                    default: {
                        isNullable = true;
                    }
                }
                int size = (Integer)columnRs.get("COLUMN_SIZE");
                int decimalDigits = (Integer)columnRs.get("DECIMAL_DIGITS");
                Column column = new Column();
                column.setName(this.quote(columnName));
                Column existing = table.getColumn(column);
                if (existing != null) {
                    throw new JDBCBinderException(column + " already exists in " + qualify);
                }
                column.setComment(comment);
                column.setSqlTypeCode(new Integer(sqlType));
                if (this.intBounds(size)) {
                    if (JDBCToHibernateTypeHelper.typeHasLength(sqlType)) {
                        column.setLength(size);
                    }
                    if (JDBCToHibernateTypeHelper.typeHasScaleAndPrecision(sqlType)) {
                        column.setPrecision(size);
                    }
                }
                if (this.intBounds(decimalDigits) && JDBCToHibernateTypeHelper.typeHasScaleAndPrecision(sqlType)) {
                    column.setScale(decimalDigits);
                }
                column.setNullable(isNullable);
                table.addColumn(column);
            }
            if (columnIterator == null) return;
        }
        catch (Throwable throwable) {
            if (columnIterator == null) throw throwable;
            try {
                this.getMetaDataDialect().close(columnIterator);
                throw throwable;
            }
            catch (JDBCException se) {
                log.warn("Exception while closing iterator for column meta data", (Throwable)se);
            }
            throw throwable;
        }
        try {
            this.getMetaDataDialect().close(columnIterator);
            return;
        }
        catch (JDBCException se) {
            log.warn("Exception while closing iterator for column meta data", (Throwable)se);
        }
    }

    private String quote(String columnName) {
        if (columnName == null) {
            return columnName;
        }
        if (this.getMetaDataDialect().needQuote(columnName)) {
            if (columnName.length() > 1 && columnName.charAt(0) == '`' && columnName.charAt(columnName.length() - 1) == '`') {
                return columnName;
            }
            return "`" + columnName + "`";
        }
        return columnName;
    }

    public MetaDataDialect getMetaDataDialect() {
        return this.metadataDialect;
    }

    private boolean intBounds(int size) {
        return size >= 0 && size != Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void processIndices(Table table) {
        indexes = new HashMap<String, Index>();
        uniquekeys = new HashMap<String, UniqueKey>();
        uniqueColumns = new HashMap<Column, ArrayList<UniqueKey>>();
        indexIterator = null;
        try {
            indexRs = null;
            indexIterator = this.getMetaDataDialect().getIndexInfo(this.getCatalogForDBLookup(table.getCatalog()), this.getSchemaForDBLookup(table.getSchema()), table.getName());
            while (indexIterator.hasNext()) {
                indexRs = (Map)indexIterator.next();
                indexName = (String)indexRs.get("INDEX_NAME");
                columnName = (String)indexRs.get("COLUMN_NAME");
                v0 = unique = (Boolean)indexRs.get("NON_UNIQUE") == false;
                if (columnName != null || indexName != null) {
                    if (unique) {
                        key = (UniqueKey)uniquekeys.get(indexName);
                        if (key == null) {
                            key = new UniqueKey();
                            key.setName(indexName);
                            key.setTable(table);
                            table.addUniqueKey(key);
                            uniquekeys.put(indexName, key);
                        }
                        if (indexes.containsKey(indexName)) {
                            throw new JDBCBinderException("UniqueKey exists also as Index! ");
                        }
                        column = this.getColumn(table, columnName);
                        key.addColumn(column);
                        if (!unique || key.getColumnSpan() != 1) continue;
                        l = (ArrayList<UniqueKey>)uniqueColumns.get(column);
                        if (l == null) {
                            l = new ArrayList<UniqueKey>();
                            uniqueColumns.put(column, l);
                        }
                        l.add(key);
                        continue;
                    }
                    index = (Index)indexes.get(indexName);
                    if (index == null) {
                        index = new Index();
                        index.setName(indexName);
                        index.setTable(table);
                        table.addIndex(index);
                        indexes.put(indexName, index);
                    }
                    if (uniquekeys.containsKey(indexName)) {
                        throw new JDBCBinderException("Index exists also as Unique! ");
                    }
                    column = this.getColumn(table, columnName);
                    index.addColumn(column);
                    continue;
                }
                if (0 == (Short)indexRs.get("TYPE")) continue;
                JDBCReader.log.warn("Index was not statistical, but no column name was found in " + indexName);
            }
            ** if (indexIterator == null) goto lbl-1000
        }
        catch (JDBCException t) {
            try {
                JDBCReader.log.warn("Exception while trying to get indexinfo on " + Table.qualify((String)table.getCatalog(), (String)table.getSchema(), (String)table.getName()) + "=" + t.getMessage());
                ** if (indexIterator == null) goto lbl-1000
            }
            catch (Throwable var13_17) {
                if (indexIterator != null) {
                    try {
                        this.getMetaDataDialect().close(indexIterator);
                    }
                    catch (JDBCException se) {
                        JDBCReader.log.warn("Exception while trying to close resultset for index meta data", (Throwable)se);
                    }
                }
                throw var13_17;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    this.getMetaDataDialect().close(indexIterator);
                }
                catch (JDBCException se) {
                    JDBCReader.log.warn("Exception while trying to close resultset for index meta data", (Throwable)se);
                }
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                this.getMetaDataDialect().close(indexIterator);
            }
            catch (JDBCException se) {
                JDBCReader.log.warn("Exception while trying to close resultset for index meta data", (Throwable)se);
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        for (Map.Entry<K, V> entry : uniqueColumns.entrySet()) {
            col = (Column)entry.getKey();
            for (UniqueKey key : (List)entry.getValue()) {
                if (key.getColumnSpan() != 1) continue;
                col.setUnique(true);
            }
        }
        iterator = uniquekeys.entrySet().iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    private void mergeMultiMap(Map dest, Map src) {
        for (Map.Entry element : src.entrySet()) {
            List existing = (List)dest.get(element.getKey());
            if (existing == null) {
                dest.put(element.getKey(), element.getValue());
                continue;
            }
            existing.addAll((List)element.getValue());
        }
    }

    private boolean equalTable(Table table1, Table table2) {
        return table1.getName().equals(table2.getName()) && this.equal(table1.getSchema(), table2.getSchema()) && this.equal(table1.getCatalog(), table2.getCatalog());
    }

    private boolean equal(String str, String str2) {
        if (str == str2) {
            return true;
        }
        return str != null && str.equals(str2);
    }

    private static void addToMultiMap(Map multimap, String key, Object item) {
        ArrayList<Object> existing = (ArrayList<Object>)multimap.get(key);
        if (existing == null) {
            existing = new ArrayList<Object>();
            multimap.put(key, existing);
        }
        existing.add(item);
    }

    private Column getColumn(Table table, String columnName) {
        Column column = new Column();
        column.setName(this.quote(columnName));
        Column existing = table.getColumn(column);
        if (existing != null) {
            column = existing;
        }
        return column;
    }

    public List readDatabaseSchema(DatabaseCollector dbs, String catalog, String schema) {
        return this.readDatabaseSchema(dbs, catalog, schema, new NoopProgressListener());
    }

    protected String getCatalogForModel(String catalog) {
        if (catalog == null) {
            return null;
        }
        if (catalog.equals(this.defaultCatalog)) {
            return null;
        }
        return catalog;
    }

    protected String getSchemaForModel(String schema) {
        if (schema == null) {
            return null;
        }
        if (schema.equals(this.defaultSchema)) {
            return null;
        }
        return schema;
    }

    protected String getCatalogForDBLookup(String catalog) {
        return catalog == null ? this.defaultCatalog : catalog;
    }

    protected String getSchemaForDBLookup(String schema) {
        return schema == null ? this.defaultSchema : schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set readSequences(String sql) {
        HashSet<String> sequences = new HashSet<String>();
        if (sql != null) {
            Connection connection = null;
            try {
                connection = this.provider.getConnection();
                Statement statement = null;
                ResultSet rs = null;
                try {
                    statement = connection.createStatement();
                    rs = statement.executeQuery(sql);
                    while (rs.next()) {
                        sequences.add(rs.getString(1).toLowerCase().trim());
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            catch (SQLException e) {
                this.sec.convert(e, "Problem while closing connection", null);
            }
            finally {
                if (connection != null) {
                    try {
                        this.provider.closeConnection(connection);
                    }
                    catch (SQLException e) {
                        this.sec.convert(e, "Problem while closing connection", null);
                    }
                }
            }
        }
        return sequences;
    }

    static class NoopProgressListener
    implements ProgressListener {
        NoopProgressListener() {
        }

        @Override
        public void startSubTask(String name) {
        }
    }

    static class ForeignKeysInfo {
        final Map dependentTables;
        final Map dependentColumns;
        final Map referencedColumns;
        private final Table referencedTable;

        public ForeignKeysInfo(Table referencedTable, Map tables, Map columns, Map refColumns) {
            this.referencedTable = referencedTable;
            this.dependentTables = tables;
            this.dependentColumns = columns;
            this.referencedColumns = refColumns;
        }

        Map process(ReverseEngineeringStrategy revengStrategy) {
            HashMap oneToManyCandidates = new HashMap();
            for (Map.Entry entry : this.dependentTables.entrySet()) {
                String fkName = (String)entry.getKey();
                Table fkTable = (Table)entry.getValue();
                List columns = (List)this.dependentColumns.get(fkName);
                List refColumns = (List)this.referencedColumns.get(fkName);
                String className = revengStrategy.tableToClassName(TableIdentifier.create(this.referencedTable));
                ForeignKey key = fkTable.createForeignKey(fkName, columns, className, refColumns);
                key.setReferencedTable(this.referencedTable);
                JDBCReader.addToMultiMap(oneToManyCandidates, className, key);
            }
            return oneToManyCandidates;
        }
    }
}

