/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbmlint.detector;

import org.hibernate.MappingException;
import org.hibernate.bytecode.internal.javassist.BytecodeProviderImpl;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Environment;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tool.hbmlint.Issue;
import org.hibernate.tool.hbmlint.IssueCollector;
import org.hibernate.tool.hbmlint.detector.EntityModelDetector;

public class InstrumentationDetector
extends EntityModelDetector {
    private boolean javassistEnabled;

    @Override
    public String getName() {
        return "instrument";
    }

    @Override
    public void initialize(Configuration cfg) {
        super.initialize(cfg);
        if (Environment.getBytecodeProvider() instanceof BytecodeProviderImpl) {
            this.javassistEnabled = true;
        }
    }

    @Override
    public void visit(Configuration cfg, PersistentClass clazz, IssueCollector collector) {
        Class mappedClass;
        try {
            mappedClass = clazz.getMappedClass();
        }
        catch (MappingException me) {
            return;
        }
        if (clazz.isLazy()) {
            try {
                mappedClass.getConstructor(new Class[0]);
            }
            catch (SecurityException me) {
            }
            catch (NoSuchMethodException e) {
                collector.reportIssue(new Issue("LAZY_NO_DEFAULT_CONSTRUCTOR", 50, "lazy='true' set for '" + clazz.getEntityName() + "', but class has no default constructor."));
                return;
            }
        } else if (this.javassistEnabled) {
            Class<?>[] interfaces = mappedClass.getInterfaces();
            boolean javaassist = false;
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> intface = interfaces[i];
                if (!intface.getName().equals("org.hibernate.bytecode.internal.javassist.FieldHandled")) continue;
                javaassist = true;
            }
            if (this.javassistEnabled && !javaassist) {
                collector.reportIssue(new Issue("LAZY_NOT_INSTRUMENTED", 100, "'" + clazz.getEntityName() + "' has lazy='false', but its class '" + mappedClass.getName() + "' has not been instrumented with javaassist"));
                return;
            }
        }
    }
}

