/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ant;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.JPAConfiguration;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.hibernate.jpa.boot.internal.EntityManagerFactoryBuilderImpl;
import org.hibernate.tool.ant.ConfigurationTask;

public class JPAConfigurationTask
extends ConfigurationTask {
    private String persistenceUnit = null;

    public JPAConfigurationTask() {
        this.setDescription("JPA Configuration");
    }

    @Override
    protected Configuration createConfiguration() {
        try {
            EntityManagerFactoryBuilderImpl entityManagerFactoryBuilderImpl;
            HashMap<Object, Object> overrides = new HashMap<Object, Object>();
            Properties p = this.getProperties();
            if (p != null) {
                overrides.putAll(p);
            }
            if ((entityManagerFactoryBuilderImpl = this.createEntityManagerFactoryBuilder(this.persistenceUnit, overrides)) == null) {
                throw new BuildException("Persistence unit not found: '" + this.persistenceUnit + "'.");
            }
            return new JPAConfiguration(entityManagerFactoryBuilderImpl);
        }
        catch (BuildException be) {
            throw be;
        }
        catch (Exception t) {
            Throwable cause = t.getCause();
            if (cause != null) {
                throw new BuildException(cause);
            }
            t.printStackTrace();
            throw new BuildException("Problems in creating a configuration for JPA. Have you remembered to add hibernate EntityManager jars to the classpath ?", (Throwable)t);
        }
    }

    @Override
    protected void doConfiguration(Configuration configuration) {
    }

    @Override
    protected void validateParameters() throws BuildException {
    }

    public String getPersistenceUnit() {
        return this.persistenceUnit;
    }

    public void setPersistenceUnit(String persistenceUnit) {
        this.persistenceUnit = persistenceUnit;
    }

    @Override
    public void setConfigurationFile(File configurationFile) {
        this.complain("configurationfile");
    }

    private void complain(String param) {
        throw new BuildException("<" + this.getTaskName() + "> currently only support autodiscovery from META-INF/persistence.xml. Thus setting the " + param + " attribute is not allowed");
    }

    private EntityManagerFactoryBuilderImpl createEntityManagerFactoryBuilder(String persistenceUnit, Map<Object, Object> properties) {
        return new PersistenceProvider().getEntityManagerFactoryBuilder(persistenceUnit, properties);
    }

    private static class PersistenceProvider
    extends HibernatePersistenceProvider {
        private PersistenceProvider() {
        }

        public EntityManagerFactoryBuilderImpl getEntityManagerFactoryBuilder(String persistenceUnit, Map<Object, Object> properties) {
            return (EntityManagerFactoryBuilderImpl)this.getEntityManagerFactoryBuilderOrNull(persistenceUnit, properties);
        }
    }
}

