/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.Map;
import org.hibernate.tool.hbm2x.ArtifactCollector;
import org.hibernate.tool.hbm2x.ExporterException;
import org.hibernate.tool.hbm2x.TemplateHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateProducer {
    private static final Logger log = LoggerFactory.getLogger(TemplateProducer.class);
    private final TemplateHelper th;
    private ArtifactCollector ac;

    public TemplateProducer(TemplateHelper th, ArtifactCollector ac) {
        this.th = th;
        this.ac = ac;
    }

    public void produce(Map<String, Object> additionalContext, String templateName, File destination, String identifier, String fileType, String rootContext) {
        String tempResult = this.produceToString(additionalContext, templateName, rootContext);
        if (tempResult.trim().length() == 0) {
            log.warn("Generated output is empty. Skipped creation for file " + destination);
            return;
        }
        OutputStreamWriter fileWriter = null;
        try {
            this.th.ensureExistence(destination);
            this.ac.addFile(destination, fileType);
            log.debug("Writing " + identifier + " to " + destination.getAbsolutePath());
            fileWriter = new FileWriter(destination);
            fileWriter.write(tempResult);
        }
        catch (Exception e) {
            throw new ExporterException("Error while writing result to file", e);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.flush();
                    fileWriter.close();
                }
                catch (IOException e) {
                    log.warn("Exception while flushing/closing " + destination, (Throwable)e);
                }
            }
        }
    }

    private String produceToString(Map<String, Object> additionalContext, String templateName, String rootContext) {
        Map<String, Object> contextForFirstPass = additionalContext;
        this.putInContext(this.th, contextForFirstPass);
        StringWriter tempWriter = new StringWriter();
        BufferedWriter bw = new BufferedWriter(tempWriter);
        this.th.processTemplate(templateName, bw, rootContext);
        this.removeFromContext(this.th, contextForFirstPass);
        try {
            bw.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Error while flushing to string", e);
        }
        return tempWriter.toString();
    }

    private void removeFromContext(TemplateHelper templateHelper, Map<String, Object> context) {
        for (Map.Entry<String, Object> element : context.entrySet()) {
            templateHelper.removeFromContext(element.getKey(), element.getValue());
        }
    }

    private void putInContext(TemplateHelper templateHelper, Map<String, Object> context) {
        for (Map.Entry<String, Object> element : context.entrySet()) {
            templateHelper.putInContext(element.getKey(), element.getValue());
        }
    }

    public void produce(Map<String, Object> additionalContext, String templateName, File outputFile, String identifier) {
        String fileType = outputFile.getName();
        fileType = fileType.substring(fileType.indexOf(46) + 1);
        this.produce(additionalContext, templateName, outputFile, identifier, fileType, null);
    }

    public void produce(Map<String, Object> additionalContext, String templateName, File outputFile, String identifier, String rootContext) {
        String fileType = outputFile.getName();
        fileType = fileType.substring(fileType.indexOf(46) + 1);
        this.produce(additionalContext, templateName, outputFile, identifier, fileType, rootContext);
    }
}

