/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.cfg.Configuration;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Component;
import org.hibernate.tool.hbm2x.AbstractExporter;
import org.hibernate.tool.hbm2x.ConfigurationNavigator;
import org.hibernate.tool.hbm2x.ExporterException;
import org.hibernate.tool.hbm2x.TemplateProducer;
import org.hibernate.tool.hbm2x.pojo.ComponentPOJOClass;
import org.hibernate.tool.hbm2x.pojo.POJOClass;
import org.hibernate.tool.util.MetadataHelper;

public class GenericExporter
extends AbstractExporter {
    static Map<String, ModelIterator> modelIterators = new HashMap<String, ModelIterator>();
    private String templateName;
    private String filePattern;
    private String forEach;
    private Metadata metadata = null;

    public GenericExporter(Configuration cfg, File outputdir) {
        super(cfg, outputdir);
    }

    public GenericExporter() {
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public void setForEach(String foreach) {
        this.forEach = foreach;
    }

    @Override
    protected void doStart() {
        if (this.filePattern == null) {
            throw new ExporterException("File pattern not set on " + this.getClass());
        }
        if (this.templateName == null) {
            throw new ExporterException("Template name not set on " + this.getClass());
        }
        ArrayList<ModelIterator> exporters = new ArrayList<ModelIterator>();
        if (StringHelper.isEmpty((String)this.forEach)) {
            if (this.filePattern.indexOf("{class-name}") >= 0) {
                exporters.add(modelIterators.get("entity"));
                exporters.add(modelIterators.get("component"));
            } else {
                exporters.add(modelIterators.get("configuration"));
            }
        } else {
            StringTokenizer tokens = new StringTokenizer(this.forEach, ",");
            while (tokens.hasMoreTokens()) {
                String nextToken = tokens.nextToken();
                ModelIterator modelIterator = modelIterators.get(nextToken);
                if (modelIterator == null) {
                    throw new ExporterException("for-each does not support [" + nextToken + "]");
                }
                exporters.add(modelIterator);
            }
        }
        for (ModelIterator mit : exporters) {
            mit.process(this);
        }
    }

    protected void exportComponent(Map<String, Object> additionalContext, POJOClass element) {
        this.exportPOJO(additionalContext, element);
    }

    protected void exportPersistentClass(Map<String, Object> additionalContext, POJOClass element) {
        this.exportPOJO(additionalContext, element);
    }

    protected void exportPOJO(Map<String, Object> additionalContext, POJOClass element) {
        TemplateProducer producer = new TemplateProducer(this.getTemplateHelper(), this.getArtifactCollector());
        additionalContext.put("pojo", element);
        additionalContext.put("clazz", element.getDecoratedObject());
        String filename = this.resolveFilename(element);
        if (filename.endsWith(".java") && filename.indexOf(36) >= 0) {
            this.log.warn("Filename for " + this.getClassNameForFile(element) + " contains a $. Innerclass generation is not supported.");
        }
        producer.produce(additionalContext, this.getTemplateName(), new File(this.getOutputDirectory(), filename), this.templateName, element.toString());
    }

    protected String resolveFilename(POJOClass element) {
        String filename = StringHelper.replace((String)this.filePattern, (String)"{class-name}", (String)this.getClassNameForFile(element));
        String packageLocation = StringHelper.replace((String)this.getPackageNameForFile(element), (String)".", (String)"/");
        if (StringHelper.isEmpty((String)packageLocation)) {
            packageLocation = ".";
        }
        filename = StringHelper.replace((String)filename, (String)"{package-name}", (String)packageLocation);
        return filename;
    }

    protected String getPackageNameForFile(POJOClass element) {
        return element.getPackageName();
    }

    protected String getClassNameForFile(POJOClass element) {
        return element.getDeclarationName();
    }

    public void setFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    private Metadata getMetadata() {
        if (this.metadata == null) {
            this.metadata = this.buildMetadata();
        }
        return this.metadata;
    }

    private Metadata buildMetadata() {
        Metadata result = null;
        Configuration configuration = this.getConfiguration();
        result = configuration != null ? MetadataHelper.getMetadata(this.getConfiguration()) : new MetadataSources().buildMetadata();
        return result;
    }

    static {
        modelIterators.put("configuration", new ModelIterator(){

            @Override
            void process(GenericExporter ge) {
                TemplateProducer producer = new TemplateProducer(ge.getTemplateHelper(), ge.getArtifactCollector());
                producer.produce(new HashMap<String, Object>(), ge.getTemplateName(), new File(ge.getOutputDirectory(), ge.filePattern), ge.templateName, "Configuration");
            }
        });
        modelIterators.put("entity", new ModelIterator(){

            @Override
            void process(GenericExporter ge) {
                Iterator<POJOClass> iterator = ge.getCfg2JavaTool().getPOJOIterator(ge.getMetadata().getEntityBindings().iterator());
                HashMap<String, Object> additionalContext = new HashMap<String, Object>();
                while (iterator.hasNext()) {
                    POJOClass element = iterator.next();
                    ge.exportPersistentClass(additionalContext, element);
                }
            }
        });
        modelIterators.put("component", new ModelIterator(){

            @Override
            void process(GenericExporter ge) {
                HashMap<String, Component> components = new HashMap<String, Component>();
                Iterator<POJOClass> iterator = ge.getCfg2JavaTool().getPOJOIterator(ge.getMetadata().getEntityBindings().iterator());
                HashMap<String, Object> additionalContext = new HashMap<String, Object>();
                while (iterator.hasNext()) {
                    POJOClass element = iterator.next();
                    ConfigurationNavigator.collectComponents(components, element);
                }
                for (Component component : components.values()) {
                    ComponentPOJOClass element = new ComponentPOJOClass(component, ge.getCfg2JavaTool());
                    ge.exportComponent(additionalContext, element);
                }
            }
        });
    }

    static abstract class ModelIterator {
        ModelIterator() {
        }

        abstract void process(GenericExporter var1);
    }
}

