/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PropertySet;
import org.hibernate.boot.MappingNotFoundException;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.cfg.Configuration;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.tool.ant.AnnotationConfigurationTask;
import org.hibernate.tool.ant.ConfigurationTask;
import org.hibernate.tool.ant.ExporterTask;
import org.hibernate.tool.ant.GenericExporterTask;
import org.hibernate.tool.ant.Hbm2CfgXmlExporterTask;
import org.hibernate.tool.ant.Hbm2DAOExporterTask;
import org.hibernate.tool.ant.Hbm2DDLExporterTask;
import org.hibernate.tool.ant.Hbm2DocExporterTask;
import org.hibernate.tool.ant.Hbm2HbmXmlExporterTask;
import org.hibernate.tool.ant.Hbm2JavaExporterTask;
import org.hibernate.tool.ant.HbmLintExporterTask;
import org.hibernate.tool.ant.JDBCConfigurationTask;
import org.hibernate.tool.ant.JPAConfigurationTask;
import org.hibernate.tool.ant.QueryExporterTask;

public class HibernateToolTask
extends Task {
    ConfigurationTask configurationTask;
    private File destDir;
    private List<ExporterTask> generators = new ArrayList<ExporterTask>();
    private Path classPath;
    private Path templatePath;
    private Properties properties = new Properties();

    private void checkConfiguration() {
        if (this.configurationTask != null) {
            throw new BuildException("Only a single configuration is allowed.");
        }
    }

    public ConfigurationTask createConfiguration() {
        this.checkConfiguration();
        this.configurationTask = new ConfigurationTask();
        return this.configurationTask;
    }

    public JDBCConfigurationTask createJDBCConfiguration() {
        this.checkConfiguration();
        this.configurationTask = new JDBCConfigurationTask();
        return (JDBCConfigurationTask)this.configurationTask;
    }

    public AnnotationConfigurationTask createAnnotationConfiguration() {
        this.checkConfiguration();
        this.configurationTask = new AnnotationConfigurationTask();
        return (AnnotationConfigurationTask)this.configurationTask;
    }

    public JPAConfigurationTask createJpaConfiguration() {
        this.checkConfiguration();
        this.configurationTask = new JPAConfigurationTask();
        return (JPAConfigurationTask)this.configurationTask;
    }

    public ExporterTask createHbm2DDL() {
        Hbm2DDLExporterTask generator = new Hbm2DDLExporterTask(this);
        this.addGenerator(generator);
        return generator;
    }

    public ExporterTask createHbmTemplate() {
        GenericExporterTask generator = new GenericExporterTask(this);
        this.addGenerator(generator);
        return generator;
    }

    public ExporterTask createHbm2CfgXml() {
        Hbm2CfgXmlExporterTask generator = new Hbm2CfgXmlExporterTask(this);
        this.addGenerator(generator);
        return generator;
    }

    protected boolean addGenerator(ExporterTask generator) {
        return this.generators.add(generator);
    }

    public ExporterTask createHbm2Java() {
        Hbm2JavaExporterTask generator = new Hbm2JavaExporterTask(this);
        this.addGenerator(generator);
        return generator;
    }

    public ExporterTask createHbm2HbmXml() {
        Hbm2HbmXmlExporterTask generator = new Hbm2HbmXmlExporterTask(this);
        this.addGenerator(generator);
        return generator;
    }

    public ExporterTask createHbm2Doc() {
        Hbm2DocExporterTask generator = new Hbm2DocExporterTask(this);
        this.addGenerator(generator);
        return generator;
    }

    public ExporterTask createHbm2DAO() {
        Hbm2DAOExporterTask generator = new Hbm2DAOExporterTask(this);
        this.addGenerator(generator);
        return generator;
    }

    public QueryExporterTask createQuery() {
        QueryExporterTask generator = new QueryExporterTask(this);
        this.generators.add(generator);
        return generator;
    }

    public HbmLintExporterTask createHbmLint() {
        HbmLintExporterTask generator = new HbmLintExporterTask(this);
        this.generators.add(generator);
        return generator;
    }

    public void setClasspath(Path s) {
        this.classPath = s;
    }

    public Path createClasspath() {
        this.classPath = new Path(this.getProject());
        return this.classPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (this.configurationTask == null) {
            throw new BuildException("No configuration specified. <" + this.getTaskName() + "> must have one of the following: <configuration>, <jpaconfiguration>, <annotationconfiguration> or <jdbcconfiguration>");
        }
        this.log("Executing Hibernate Tool with a " + this.configurationTask.getDescription());
        this.validateParameters();
        Iterator<ExporterTask> iterator = this.generators.iterator();
        AntClassLoader loader = this.getProject().createClassLoader(this.classPath);
        ExporterTask generatorTask = null;
        int count = 1;
        try {
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            loader.setParent(classLoader);
            loader.setThreadContextLoader();
            while (iterator.hasNext()) {
                generatorTask = iterator.next();
                this.log(count++ + ". task: " + generatorTask.getName());
                generatorTask.execute();
            }
        }
        catch (RuntimeException re) {
            this.reportException(re, count, generatorTask);
        }
        finally {
            if (loader != null) {
                loader.resetThreadContextLoader();
                loader.cleanup();
            }
        }
    }

    private void reportException(Throwable re, int count, ExporterTask generatorTask) {
        String newbieMessage;
        this.log("An exception occurred while running exporter #" + count + ":" + generatorTask.getName(), 0);
        this.log("To get the full stack trace run ant with -verbose", 0);
        this.log(re.toString(), 0);
        String ex = new String();
        for (Throwable cause = re.getCause(); cause != null; cause = cause.getCause()) {
            ex = ex + cause.toString() + "\n";
            if (cause == cause.getCause()) break;
        }
        if (StringHelper.isNotEmpty((String)ex)) {
            this.log(ex, 0);
        }
        if ((newbieMessage = this.getProbableSolutionOrCause(re)) != null) {
            this.log(newbieMessage);
        }
        if (re instanceof BuildException) {
            throw (BuildException)re;
        }
        throw new BuildException(re, this.getLocation());
    }

    private String getProbableSolutionOrCause(Throwable re) {
        if (re == null) {
            return null;
        }
        if (re instanceof MappingNotFoundException) {
            MappingNotFoundException mnf = (MappingNotFoundException)re;
            Origin origin = mnf.getOrigin();
            return "A " + origin.getType() + " located at " + origin.getName() + " was not found.\n" + "Check the following:\n" + "\n" + "1) Is the spelling/casing correct ?\n" + "2)\tIs " + mnf.getOrigin().getName() + " available via the classpath ?\n" + "3) Does it actually exist ?\n";
        }
        if (re instanceof ClassNotFoundException || re instanceof NoClassDefFoundError) {
            return "A class were not found in the classpath of the Ant task.\nEnsure that the classpath contains the classes needed for Hibernate and your code are in the classpath.\n";
        }
        if (re instanceof UnsupportedClassVersionError) {
            return "You are most likely running the ant task with a JRE that is older than the JRE required to use the classes.\ne.g. running with JRE 1.3 or 1.4 when using JDK 1.5 annotations is not possible.\nEnsure that you are using a correct JRE.";
        }
        if (re.getCause() != re) {
            return this.getProbableSolutionOrCause(re.getCause());
        }
        return null;
    }

    private void validateParameters() {
        if (this.generators.isEmpty()) {
            throw new BuildException("No exporters specified in <hibernatetool>. There has to be at least one specified. An exporter is e.g. <hbm2java> or <hbmtemplate>. See documentation for details.", this.getLocation());
        }
        for (ExporterTask generatorTask : this.generators) {
            generatorTask.validateParameters();
        }
    }

    public File getDestDir() {
        return this.destDir;
    }

    public void setDestDir(File file) {
        this.destDir = file;
    }

    public Configuration getConfiguration() {
        return this.configurationTask.getConfiguration();
    }

    public void setTemplatePath(Path path) {
        this.templatePath = path;
    }

    public Path getTemplatePath() {
        if (this.templatePath == null) {
            this.templatePath = new Path(this.getProject());
        }
        return this.templatePath;
    }

    public Properties getProperties() {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this.getConfiguration().getProperties());
        p.putAll((Map<?, ?>)this.properties);
        return p;
    }

    public void addConfiguredPropertySet(PropertySet ps) {
        this.properties.putAll((Map<?, ?>)ps.getProperties());
    }

    public void addConfiguredProperty(Environment.Variable property) {
        this.properties.put(property.getKey(), property.getValue());
    }
}

