/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.hibernate.cfg.reveng.AssociationInfo;
import org.hibernate.cfg.reveng.JDBCToHibernateTypeHelper;
import org.hibernate.cfg.reveng.ReverseEngineeringRuntimeInfo;
import org.hibernate.cfg.reveng.ReverseEngineeringSettings;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategyUtil;
import org.hibernate.cfg.reveng.SchemaSelection;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Table;
import org.hibernate.tool.util.TableNameQualifier;
import org.jboss.logging.Logger;

public class DefaultReverseEngineeringStrategy
implements ReverseEngineeringStrategy {
    private static final Logger log = Logger.getLogger(DefaultReverseEngineeringStrategy.class);
    private static Set<String> AUTO_OPTIMISTICLOCK_COLUMNS = new HashSet<String>();
    private ReverseEngineeringSettings settings = new ReverseEngineeringSettings(this);
    private ReverseEngineeringRuntimeInfo runtimeInfo;

    @Override
    public String columnToPropertyName(TableIdentifier table, String columnName) {
        String decapitalize = Introspector.decapitalize(this.toUpperCamelCase(columnName));
        return this.keywordCheck(decapitalize);
    }

    private String keywordCheck(String possibleKeyword) {
        if (ReverseEngineeringStrategyUtil.isReservedJavaKeyword(possibleKeyword)) {
            possibleKeyword = possibleKeyword + "_";
        }
        return possibleKeyword;
    }

    protected String toUpperCamelCase(String s) {
        return ReverseEngineeringStrategyUtil.toUpperCamelCase(s);
    }

    @Override
    public String foreignKeyToCollectionName(String keyname, TableIdentifier fromTable, List<?> fromColumns, TableIdentifier referencedTable, List<?> referencedColumns, boolean uniqueReference) {
        String propertyName = Introspector.decapitalize(StringHelper.unqualify((String)this.getRoot().tableToClassName(fromTable)));
        propertyName = this.pluralize(propertyName);
        if (!uniqueReference) {
            if (fromColumns != null && fromColumns.size() == 1) {
                String columnName = ((Column)fromColumns.get(0)).getName();
                propertyName = propertyName + "For" + this.toUpperCamelCase(columnName);
            } else {
                propertyName = propertyName + "For" + this.toUpperCamelCase(keyname);
            }
        }
        return propertyName;
    }

    protected String pluralize(String singular) {
        return ReverseEngineeringStrategyUtil.simplePluralize(singular);
    }

    @Override
    public String foreignKeyToInverseEntityName(String keyname, TableIdentifier fromTable, List<?> fromColumnNames, TableIdentifier referencedTable, List<?> referencedColumnNames, boolean uniqueReference) {
        return this.foreignKeyToEntityName(keyname, fromTable, fromColumnNames, referencedTable, referencedColumnNames, uniqueReference);
    }

    @Override
    public String foreignKeyToEntityName(String keyname, TableIdentifier fromTable, List<?> fromColumnNames, TableIdentifier referencedTable, List<?> referencedColumnNames, boolean uniqueReference) {
        String propertyName = Introspector.decapitalize(StringHelper.unqualify((String)this.getRoot().tableToClassName(referencedTable)));
        if (!uniqueReference) {
            if (fromColumnNames != null && fromColumnNames.size() == 1) {
                String columnName = ((Column)fromColumnNames.get(0)).getName();
                propertyName = propertyName + "By" + this.toUpperCamelCase(columnName);
            } else {
                propertyName = propertyName + "By" + this.toUpperCamelCase(keyname);
            }
        }
        return propertyName;
    }

    @Override
    public String columnToHibernateTypeName(TableIdentifier table, String columnName, int sqlType, int length, int precision, int scale, boolean nullable, boolean generatedIdentifier) {
        String preferredHibernateType = JDBCToHibernateTypeHelper.getPreferredHibernateType(sqlType, length, precision, scale, nullable, generatedIdentifier);
        String location = "<no info>";
        if (log.isDebugEnabled()) {
            String info = " t:" + JDBCToHibernateTypeHelper.getJDBCTypeName(sqlType) + " l:" + length + " p:" + precision + " s:" + scale + " n:" + nullable + " id:" + generatedIdentifier;
            location = table != null ? TableNameQualifier.qualify(table.getCatalog(), table.getSchema(), table.getName()) + "." + columnName + info : location + " Column: " + columnName + info;
        }
        if (preferredHibernateType == null) {
            log.debug((Object)("No default type found for [" + location + "] falling back to [serializable]"));
            return "serializable";
        }
        log.debug((Object)("Default type found for [" + location + "] to [" + preferredHibernateType + "]"));
        return preferredHibernateType;
    }

    @Override
    public boolean excludeTable(TableIdentifier ti) {
        return false;
    }

    @Override
    public boolean excludeColumn(TableIdentifier identifier, String columnName) {
        return false;
    }

    @Override
    public String tableToClassName(TableIdentifier tableIdentifier) {
        String pkgName = this.settings.getDefaultPackageName();
        String className = this.toUpperCamelCase(tableIdentifier.getName());
        if (pkgName.length() > 0) {
            return StringHelper.qualify((String)pkgName, (String)className);
        }
        return className;
    }

    @Override
    public List<ForeignKey> getForeignKeys(TableIdentifier referencedTable) {
        return Collections.emptyList();
    }

    @Override
    public String getTableIdentifierStrategyName(TableIdentifier identifier) {
        return null;
    }

    @Override
    public Properties getTableIdentifierProperties(TableIdentifier identifier) {
        return null;
    }

    @Override
    public List<String> getPrimaryKeyColumnNames(TableIdentifier identifier) {
        return null;
    }

    @Override
    public String classNameToCompositeIdName(String className) {
        return className + "Id";
    }

    @Override
    public void configure(ReverseEngineeringRuntimeInfo rti) {
        this.runtimeInfo = rti;
    }

    @Override
    public void close() {
    }

    @Override
    public String getOptimisticLockColumnName(TableIdentifier identifier) {
        return null;
    }

    @Override
    public boolean useColumnForOptimisticLock(TableIdentifier identifier, String column) {
        if (this.settings.getDetectOptimsticLock()) {
            return AUTO_OPTIMISTICLOCK_COLUMNS.contains(column.toLowerCase());
        }
        return false;
    }

    @Override
    public List<SchemaSelection> getSchemaSelections() {
        return null;
    }

    @Override
    public String tableToIdentifierPropertyName(TableIdentifier tableIdentifier) {
        return null;
    }

    @Override
    public String tableToCompositeIdName(TableIdentifier identifier) {
        return null;
    }

    @Override
    public boolean excludeForeignKeyAsCollection(String keyname, TableIdentifier fromTable, List<Column> fromColumns, TableIdentifier referencedTable, List<Column> referencedColumns) {
        return !this.settings.createCollectionForForeignKey();
    }

    @Override
    public boolean excludeForeignKeyAsManytoOne(String keyname, TableIdentifier fromTable, List<?> fromColumns, TableIdentifier referencedTable, List<?> referencedColumns) {
        return !this.settings.createManyToOneForForeignKey();
    }

    @Override
    public boolean isForeignKeyCollectionInverse(String name, TableIdentifier foreignKeyTable, List<?> columns, TableIdentifier foreignKeyReferencedTable, List<?> referencedColumns) {
        Table fkTable = this.getRuntimeInfo().getTable(foreignKeyTable);
        if (fkTable == null) {
            return true;
        }
        if (this.isManyToManyTable(fkTable)) {
            Column column = fkTable.getColumn(0);
            Column fkColumn = (Column)referencedColumns.get(0);
            return fkColumn.equals(column);
        }
        return true;
    }

    @Override
    public boolean isForeignKeyCollectionLazy(String name, TableIdentifier foreignKeyTable, List<?> columns, TableIdentifier foreignKeyReferencedTable, List<?> referencedColumns) {
        return true;
    }

    @Override
    public void setSettings(ReverseEngineeringSettings settings) {
        this.settings = settings;
    }

    @Override
    public boolean isOneToOne(ForeignKey foreignKey) {
        if (this.settings.getDetectOneToOne()) {
            List fkColumns = foreignKey.getColumns();
            List pkForeignTableColumns = null;
            if (foreignKey.getTable().hasPrimaryKey()) {
                pkForeignTableColumns = foreignKey.getTable().getPrimaryKey().getColumns();
            }
            boolean equals = fkColumns != null && pkForeignTableColumns != null && fkColumns.size() == pkForeignTableColumns.size();
            Iterator columns = foreignKey.getColumnIterator();
            while (equals && columns.hasNext()) {
                Column fkColumn = (Column)columns.next();
                equals = equals && pkForeignTableColumns.contains(fkColumn);
            }
            return equals;
        }
        return false;
    }

    @Override
    public boolean isManyToManyTable(Table table) {
        if (this.settings.getDetectManyToMany()) {
            PrimaryKey pk = table.getPrimaryKey();
            if (pk == null || pk.getColumns().size() != table.getColumnSpan()) {
                return false;
            }
            Iterator foreignKeyIterator = table.getForeignKeyIterator();
            ArrayList<ForeignKey> foreignKeys = new ArrayList<ForeignKey>();
            while (foreignKeyIterator.hasNext()) {
                ForeignKey fkey = (ForeignKey)foreignKeyIterator.next();
                foreignKeys.add(fkey);
                if (foreignKeys.size() <= 2) continue;
                return false;
            }
            if (foreignKeys.size() != 2) {
                return false;
            }
            HashSet<Column> columns = new HashSet<Column>();
            Iterator columnIterator = table.getColumnIterator();
            while (columnIterator.hasNext()) {
                Column column = (Column)columnIterator.next();
                columns.add(column);
            }
            foreignKeyIterator = table.getForeignKeyIterator();
            while (!columns.isEmpty() && foreignKeyIterator.hasNext()) {
                ForeignKey element = (ForeignKey)foreignKeyIterator.next();
                columns.removeAll(element.getColumns());
            }
            return columns.isEmpty();
        }
        return false;
    }

    protected ReverseEngineeringStrategy getRoot() {
        return this.settings.getRootStrategy();
    }

    protected ReverseEngineeringRuntimeInfo getRuntimeInfo() {
        return this.runtimeInfo;
    }

    @Override
    public String foreignKeyToManyToManyName(ForeignKey fromKey, TableIdentifier middleTable, ForeignKey toKey, boolean uniqueReference) {
        String propertyName = Introspector.decapitalize(StringHelper.unqualify((String)this.getRoot().tableToClassName(TableIdentifier.create(toKey.getReferencedTable()))));
        propertyName = this.pluralize(propertyName);
        if (!uniqueReference) {
            if (toKey.getColumns() != null && toKey.getColumns().size() == 1) {
                String columnName = ((Column)toKey.getColumns().get(0)).getName();
                propertyName = propertyName + "For" + this.toUpperCamelCase(columnName);
            } else {
                propertyName = propertyName + "For" + this.toUpperCamelCase(toKey.getName());
            }
        }
        return propertyName;
    }

    @Override
    public Map<String, MetaAttribute> tableToMetaAttributes(TableIdentifier tableIdentifier) {
        return null;
    }

    @Override
    public Map<String, MetaAttribute> columnToMetaAttributes(TableIdentifier identifier, String column) {
        return null;
    }

    @Override
    public AssociationInfo foreignKeyToAssociationInfo(ForeignKey foreignKey) {
        return null;
    }

    @Override
    public AssociationInfo foreignKeyToInverseAssociationInfo(ForeignKey foreignKey) {
        return null;
    }

    static {
        AUTO_OPTIMISTICLOCK_COLUMNS.add("version");
        AUTO_OPTIMISTICLOCK_COLUMNS.add("timestamp");
    }
}

