/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x.doc;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DocFolder {
    private String name;
    private DocFolder parent;
    private File file;
    private List<DocFolder> pathFolders = new ArrayList<DocFolder>();

    public DocFolder(File root) {
        if (root == null) {
            throw new IllegalArgumentException("Root File cannot be null");
        }
        this.file = root;
        this.pathFolders.add(this);
    }

    public DocFolder(String pName, DocFolder pParent) {
        if (pName == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (pParent == null) {
            throw new IllegalArgumentException("Parent folder cannot be null");
        }
        this.name = pName;
        this.parent = pParent;
        this.file = new File(this.parent.getFile(), this.name);
        if (this.file.exists()) {
            if (!this.file.isDirectory()) {
                throw new RuntimeException("The path: " + this.file.getAbsolutePath() + " exists, but is not a Folder");
            }
        } else if (!this.file.mkdirs()) {
            throw new RuntimeException("unable to create folder: " + this.file.getAbsolutePath());
        }
        if (this.parent != null) {
            this.pathFolders.addAll(this.parent.getPathFolders());
            this.pathFolders.add(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public DocFolder getParent() {
        return this.parent;
    }

    public File getFile() {
        return this.file;
    }

    public List<DocFolder> getPathFolders() {
        return this.pathFolders;
    }

    public String toString() {
        return this.name;
    }
}

