/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.JDBCException;
import org.hibernate.MappingException;
import org.hibernate.cfg.JDBCBinderException;
import org.hibernate.cfg.reveng.DatabaseCollector;
import org.hibernate.cfg.reveng.ForeignKeysInfo;
import org.hibernate.cfg.reveng.ProgressListener;
import org.hibernate.cfg.reveng.RevEngUtils;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.cfg.reveng.dialect.MetaDataDialect;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.tool.util.TableNameQualifier;
import org.jboss.logging.Logger;

public class ForeignKeyProcessor {
    private static final Logger log = Logger.getLogger(ForeignKeyProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ForeignKeysInfo processForeignKeys(MetaDataDialect metaDataDialect, ReverseEngineeringStrategy revengStrategy, String defaultSchema, String defaultCatalog, DatabaseCollector dbs, Table referencedTable, ProgressListener progress) throws JDBCBinderException {
        HashMap<String, List<Column>> dependentColumns = new HashMap<String, List<Column>>();
        HashMap<String, Table> dependentTables = new HashMap<String, Table>();
        HashMap<String, List<Column>> referencedColumns = new HashMap<String, List<Column>>();
        short bogusFkName = 0;
        Iterator<Map<String, Object>> exportedKeyIterator = null;
        log.debug((Object)("Calling getExportedKeys on " + referencedTable));
        progress.startSubTask("Finding exported foreignkeys on " + referencedTable.getName());
        try {
            Map<String, Object> exportedKeyRs = null;
            exportedKeyIterator = metaDataDialect.getExportedKeys(ForeignKeyProcessor.getCatalogForDBLookup(referencedTable.getCatalog(), defaultCatalog), ForeignKeyProcessor.getSchemaForDBLookup(referencedTable.getSchema(), defaultSchema), referencedTable.getName());
            try {
                while (exportedKeyIterator.hasNext()) {
                    Column refColumn;
                    ArrayList<Column> depColumns;
                    exportedKeyRs = exportedKeyIterator.next();
                    String fkCatalog = ForeignKeyProcessor.getCatalogForModel((String)exportedKeyRs.get("FKTABLE_CAT"), defaultCatalog);
                    String fkSchema = ForeignKeyProcessor.getSchemaForModel((String)exportedKeyRs.get("FKTABLE_SCHEM"), defaultSchema);
                    String fkTableName = (String)exportedKeyRs.get("FKTABLE_NAME");
                    String fkColumnName = (String)exportedKeyRs.get("FKCOLUMN_NAME");
                    String pkColumnName = (String)exportedKeyRs.get("PKCOLUMN_NAME");
                    String fkName = (String)exportedKeyRs.get("FK_NAME");
                    short keySeq = (Short)exportedKeyRs.get("KEY_SEQ");
                    Table fkTable = dbs.getTable((String)exportedKeyRs.get("FKTABLE_SCHEM"), (String)exportedKeyRs.get("FKTABLE_CAT"), fkTableName);
                    if (fkTable == null) {
                        fkTable = dbs.getTable(ForeignKeyProcessor.getSchemaForModel(fkSchema, defaultSchema), ForeignKeyProcessor.getCatalogForModel(fkCatalog, defaultCatalog), fkTableName);
                    }
                    if (fkTable == null) {
                        log.debug((Object)("Foreign key " + fkName + " references unknown or filtered table " + TableNameQualifier.qualify(fkCatalog, fkSchema, fkTableName)));
                        continue;
                    }
                    log.debug((Object)("Foreign key " + fkName));
                    if (keySeq == 0) {
                        bogusFkName = (short)(bogusFkName + 1);
                    }
                    if (fkName == null) {
                        fkName = Short.toString(bogusFkName);
                    }
                    if ((depColumns = (ArrayList<Column>)dependentColumns.get(fkName)) == null) {
                        depColumns = new ArrayList<Column>();
                        dependentColumns.put(fkName, depColumns);
                        dependentTables.put(fkName, fkTable);
                    } else {
                        Object previousTable = dependentTables.get(fkName);
                        if (fkTable != previousTable) {
                            throw new JDBCBinderException("Foreign key name (" + fkName + ") mapped to different tables! previous: " + previousTable + " current:" + fkTable);
                        }
                    }
                    Column column = new Column(fkColumnName);
                    Column existingColumn = fkTable.getColumn(column);
                    column = existingColumn == null ? column : existingColumn;
                    depColumns.add(column);
                    ArrayList<Column> primColumns = (ArrayList<Column>)referencedColumns.get(fkName);
                    if (primColumns == null) {
                        primColumns = new ArrayList<Column>();
                        referencedColumns.put(fkName, primColumns);
                    }
                    refColumn = (existingColumn = referencedTable.getColumn(refColumn = new Column(pkColumnName))) == null ? refColumn : existingColumn;
                    primColumns.add(refColumn);
                }
            }
            finally {
                try {
                    if (exportedKeyIterator != null) {
                        metaDataDialect.close(exportedKeyIterator);
                    }
                }
                catch (JDBCException se) {
                    log.warn((Object)"Exception while closing result set for foreign key meta data", (Throwable)se);
                }
            }
        }
        catch (JDBCException se) {
            log.warn((Object)("Exception while reading foreign keys for " + referencedTable + " [" + se.toString() + "]"), (Throwable)se);
        }
        List<ForeignKey> userForeignKeys = revengStrategy.getForeignKeys(RevEngUtils.createTableIdentifier(referencedTable, defaultCatalog, defaultSchema));
        if (userForeignKeys != null) {
            for (ForeignKey element : userForeignKeys) {
                if (!ForeignKeyProcessor.equalTable(referencedTable, element.getReferencedTable(), defaultSchema, defaultCatalog)) {
                    log.debug((Object)("Referenced table " + element.getReferencedTable().getName() + " is not " + referencedTable + ". Ignoring userdefined foreign key " + element));
                    continue;
                }
                String userfkName = element.getName();
                Table userfkTable = element.getTable();
                List userColumns = element.getColumns();
                List userrefColumns = element.getReferencedColumns();
                Table deptable = (Table)dependentTables.get(userfkName);
                if (deptable != null) {
                    throw new MappingException("Foreign key " + userfkName + " already defined in the database!");
                }
                deptable = dbs.getTable(ForeignKeyProcessor.getSchemaForDBLookup(userfkTable.getSchema(), defaultSchema), ForeignKeyProcessor.getCatalogForDBLookup(userfkTable.getCatalog(), defaultCatalog), userfkTable.getName());
                if (deptable == null) {
                    log.debug((Object)("User defined foreign key " + userfkName + " references unknown or filtered table " + TableIdentifier.create(userfkTable)));
                    continue;
                }
                dependentTables.put(userfkName, deptable);
                ArrayList<Column> depColumns = new ArrayList<Column>(userColumns.size());
                for (Column jdbcColumn : userColumns) {
                    Column column = new Column(jdbcColumn.getName());
                    Column existingColumn = deptable.getColumn(column);
                    column = existingColumn == null ? column : existingColumn;
                    depColumns.add(column);
                }
                ArrayList<Column> refColumns = new ArrayList<Column>(userrefColumns.size());
                for (Column jdbcColumn : userrefColumns) {
                    Column column = new Column(jdbcColumn.getName());
                    Column existingColumn = referencedTable.getColumn(column);
                    column = existingColumn == null ? column : existingColumn;
                    refColumns.add(column);
                }
                referencedColumns.put(userfkName, refColumns);
                dependentColumns.put(userfkName, depColumns);
            }
        }
        return new ForeignKeysInfo(referencedTable, dependentTables, dependentColumns, referencedColumns);
    }

    private static String getCatalogForDBLookup(String catalog, String defaultCatalog) {
        return catalog == null ? defaultCatalog : catalog;
    }

    private static String getSchemaForDBLookup(String schema, String defaultSchema) {
        return schema == null ? defaultSchema : schema;
    }

    private static String getCatalogForModel(String catalog, String defaultCatalog) {
        if (catalog == null) {
            return null;
        }
        if (catalog.equals(defaultCatalog)) {
            return null;
        }
        return catalog;
    }

    private static String getSchemaForModel(String schema, String defaultSchema) {
        if (schema == null) {
            return null;
        }
        if (schema.equals(defaultSchema)) {
            return null;
        }
        return schema;
    }

    private static boolean equalTable(Table table1, Table table2, String defaultSchema, String defaultCatalog) {
        return table1.getName().equals(table2.getName()) && ForeignKeyProcessor.equal(ForeignKeyProcessor.getSchemaForModel(table1.getSchema(), defaultSchema), ForeignKeyProcessor.getSchemaForModel(table2.getSchema(), defaultSchema)) && ForeignKeyProcessor.equal(ForeignKeyProcessor.getCatalogForModel(table1.getCatalog(), defaultCatalog), ForeignKeyProcessor.getCatalogForModel(table2.getCatalog(), defaultCatalog));
    }

    private static boolean equal(String str, String str2) {
        if (str == str2) {
            return true;
        }
        return str != null && str.equals(str2);
    }
}

