/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategyUtil;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.MetaAttributable;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.tool.hbm2x.Cfg2HbmTool;
import org.hibernate.tool.hbm2x.ExporterException;
import org.hibernate.tool.hbm2x.MetaAttributeHelper;
import org.hibernate.tool.hbm2x.StringUtils;
import org.hibernate.tool.hbm2x.pojo.ComponentPOJOClass;
import org.hibernate.tool.hbm2x.pojo.EntityPOJOClass;
import org.hibernate.tool.hbm2x.pojo.ImportContext;
import org.hibernate.tool.hbm2x.pojo.NoopImportContext;
import org.hibernate.tool.hbm2x.pojo.POJOClass;
import org.hibernate.tool.hbm2x.visitor.JavaTypeFromValueVisitor;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class Cfg2JavaTool {
    private static final Logger log = Logger.getLogger(Cfg2JavaTool.class);
    private static final Map<String, String> PRIMITIVES = new HashMap<String, String>();

    public POJOClass getPOJOClass(Component comp) {
        return new ComponentPOJOClass(comp, this);
    }

    public POJOClass getPOJOClass(PersistentClass comp) {
        return new EntityPOJOClass(comp, this);
    }

    public String unqualify(String name) {
        return StringHelper.unqualify((String)name);
    }

    public String getMetaAsString(MetaAttributable pc, String attribute) {
        MetaAttribute c = pc.getMetaAttribute(attribute);
        return MetaAttributeHelper.getMetaAsString(c);
    }

    public boolean hasMetaAttribute(MetaAttributable pc, String attribute) {
        return pc.getMetaAttribute(attribute) != null;
    }

    public String getMetaAsString(MetaAttributable pc, String attribute, String seperator) {
        return MetaAttributeHelper.getMetaAsString(pc.getMetaAttribute(attribute), seperator);
    }

    public boolean getMetaAsBool(MetaAttributable ma, String attribute) {
        return this.getMetaAsBool(ma, attribute, false);
    }

    public boolean getMetaAsBool(MetaAttributable pc, String attribute, boolean defaultValue) {
        return MetaAttributeHelper.getMetaAsBool(pc.getMetaAttribute(attribute), defaultValue);
    }

    public String toJavaDoc(String string, int indent) {
        StringBuffer result = new StringBuffer();
        if (string != null) {
            String[] lines = StringUtils.split(string, "\n\r\f");
            for (int i = 0; i < lines.length; ++i) {
                String docline = " * " + lines[i];
                if (i < lines.length - 1) {
                    docline = docline + "\n";
                }
                result.append(StringUtils.leftPad(docline, docline.length() + indent));
            }
        }
        return result.toString();
    }

    public String getClassModifiers(MetaAttributable pc) {
        String classModifiers = null;
        if (pc.getMetaAttribute("scope-class") != null) {
            classModifiers = this.getMetaAsString(pc, "scope-class").trim();
        }
        if (pc.getMetaAttribute("class-modifier") != null) {
            classModifiers = this.getMetaAsString(pc, "class-modifier").trim();
        }
        return classModifiers == null ? "public" : classModifiers;
    }

    private String toName(Class<?> c) {
        if (c.isArray()) {
            Class<?> a = c.getComponentType();
            return a.getName() + "[]";
        }
        return c.getName();
    }

    public String getJavaTypeName(Property p, boolean useGenerics) {
        return this.getJavaTypeName(p, useGenerics, new NoopImportContext());
    }

    public String getJavaTypeName(Property p, boolean useGenerics, ImportContext importContext) {
        String overrideType = this.getMetaAsString((MetaAttributable)p, "property-type");
        if (!StringHelper.isEmpty((String)overrideType)) {
            String importType = importContext.importType(overrideType);
            if (useGenerics && importType.indexOf("<") < 0 && p.getValue() instanceof Collection) {
                String decl = this.getGenericCollectionDeclaration((Collection)p.getValue(), true, importContext);
                return importType + decl;
            }
            return importType;
        }
        String rawType = this.getRawTypeName(p, useGenerics, true, importContext);
        if (rawType == null) {
            throw new IllegalStateException("getJavaTypeName *must* return a value");
        }
        return importContext.importType(rawType);
    }

    public static boolean isNonPrimitiveTypeName(String typeName) {
        return !PRIMITIVES.containsKey(typeName) && new BasicTypeRegistry().getRegisteredType(typeName) != null;
    }

    private String getRawTypeName(Property p, boolean useGenerics, boolean preferRawTypeNames, ImportContext importContext) {
        Value value = p.getValue();
        try {
            if (value instanceof Array) {
                Array a = (Array)value;
                if (a.isPrimitiveArray()) {
                    return this.toName(value.getType().getReturnedClass());
                }
                if (a.getElementClassName() != null) {
                    return a.getElementClassName() + "[]";
                }
                return this.getJavaTypeName(a.getElement(), preferRawTypeNames) + "[]";
            }
            if (value instanceof Component) {
                Component component = (Component)value;
                if (component.isDynamic()) {
                    return "java.util.Map";
                }
                return component.getComponentClassName();
            }
            if (useGenerics && value instanceof Collection) {
                String decl = this.getGenericCollectionDeclaration((Collection)value, preferRawTypeNames, importContext);
                return this.getJavaTypeName(value, preferRawTypeNames) + decl;
            }
            return this.getJavaTypeName(value, preferRawTypeNames);
        }
        catch (Exception e) {
            String msg = "Could not resolve type without exception for " + p + " Value: " + value;
            if (value != null && value.isSimpleValue()) {
                String typename = ((SimpleValue)value).getTypeName();
                log.warn((Object)(msg + ". Falling back to typename: " + typename));
                return typename;
            }
            throw new ExporterException(msg, e);
        }
    }

    public String getGenericCollectionDeclaration(Collection collection, boolean preferRawTypeNames, ImportContext importContext) {
        IndexedCollection idxCol;
        String elementType;
        Value element = collection.getElement();
        String genericDecl = elementType = importContext.importType(this.getJavaTypeName(element, preferRawTypeNames));
        if (collection.isIndexed() && !(idxCol = (IndexedCollection)collection).isList()) {
            Value idxElement = idxCol.getIndex();
            String indexType = importContext.importType(this.getJavaTypeName(idxElement, preferRawTypeNames));
            genericDecl = indexType + "," + elementType;
        }
        String decl = "<" + genericDecl + ">";
        return decl;
    }

    public Properties getFilteredIdentifierGeneratorProperties(SimpleValue simpleValue) {
        Properties p = simpleValue.getIdentifierGeneratorProperties();
        return Cfg2HbmTool.getFilteredIdentifierGeneratorProperties(p, new Properties());
    }

    private String getJavaTypeName(Value value, boolean preferRawTypeNames) {
        return (String)value.accept((ValueVisitor)new JavaTypeFromValueVisitor());
    }

    public String asParameterList(Iterator<?> fields, boolean useGenerics, ImportContext ic) {
        StringBuffer buf = new StringBuffer();
        while (fields.hasNext()) {
            Property field = (Property)fields.next();
            buf.append(this.getJavaTypeName(field, useGenerics, ic)).append(" ").append(this.keyWordCheck(field.getName()));
            if (!fields.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public String asArgumentList(Iterator<?> fields) {
        StringBuffer buf = new StringBuffer();
        while (fields.hasNext()) {
            Property field = (Property)fields.next();
            buf.append(this.keyWordCheck(field.getName()));
            if (!fields.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public String asNaturalIdParameterList(PersistentClass clazz) {
        Iterator fields = clazz.getRootClass().getPropertyIterator();
        StringBuffer buf = new StringBuffer();
        while (fields.hasNext()) {
            Property field = (Property)fields.next();
            if (!field.isNaturalIdentifier()) continue;
            buf.append(this.getJavaTypeName(field, false)).append(" ").append(field.getName()).append(", ");
        }
        return buf.substring(0, buf.length() - 2);
    }

    public String asParameterList(List<Property> fields, boolean useGenerics, ImportContext ic) {
        return this.asParameterList(fields.iterator(), useGenerics, ic);
    }

    public String asArgumentList(List<Property> fields) {
        return this.asArgumentList(fields.iterator());
    }

    public String asFinderArgumentList(Map<Object, Object> parameterTypes, ImportContext ctx) {
        StringBuffer buf = new StringBuffer();
        Iterator<Map.Entry<Object, Object>> iter = parameterTypes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            String typename = null;
            BasicType type = null;
            if (entry.getValue() instanceof String) {
                try {
                    type = new TypeConfiguration().getBasicTypeRegistry().getRegisteredType((String)entry.getValue());
                }
                catch (Throwable t) {
                    type = null;
                    typename = (String)entry.getValue();
                }
            }
            if (type != null) {
                typename = type.getReturnedClass().getName();
            }
            buf.append(ctx.importType(typename)).append(" ").append(entry.getKey());
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public boolean isPrimitive(String typeName) {
        return PRIMITIVES.containsKey(typeName);
    }

    public boolean isComponent(Property property) {
        return this.isComponent(property.getValue());
    }

    public boolean isComponent(Value value) {
        return value instanceof Component;
    }

    public Iterator<POJOClass> getPOJOIterator(final Iterator<PersistentClass> persistentClasses) {
        return new Iterator<POJOClass>(){

            @Override
            public POJOClass next() {
                return Cfg2JavaTool.this.getPOJOClass((PersistentClass)persistentClasses.next());
            }

            @Override
            public boolean hasNext() {
                return persistentClasses.hasNext();
            }

            @Override
            public void remove() {
                persistentClasses.remove();
            }
        };
    }

    public String simplePluralize(String str) {
        return ReverseEngineeringStrategyUtil.simplePluralize(str);
    }

    public String keyWordCheck(String possibleKeyword) {
        if (ReverseEngineeringStrategyUtil.isReservedJavaKeyword(possibleKeyword)) {
            possibleKeyword = possibleKeyword + "_";
        }
        return possibleKeyword;
    }

    public boolean isArray(String typeName) {
        return typeName != null && typeName.endsWith("[]");
    }

    public Map<?, ?> getParameterTypes(NamedQueryDefinition query) {
        HashMap result = query.getParameterTypes();
        if (result == null) {
            result = new HashMap();
        }
        return result;
    }

    static {
        PRIMITIVES.put("char", "Character");
        PRIMITIVES.put("byte", "Byte");
        PRIMITIVES.put("short", "Short");
        PRIMITIVES.put("int", "Integer");
        PRIMITIVES.put("long", "Long");
        PRIMITIVES.put("boolean", "Boolean");
        PRIMITIVES.put("float", "Float");
        PRIMITIVES.put("double", "Double");
    }
}

