/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.util;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;
import org.hibernate.validator.ap.checks.ConstraintCheckError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagerAdapter {
    private final ResourceBundle errorMessages;
    private final Messager messager;
    private Diagnostic.Kind diagnosticKind;

    public MessagerAdapter(Messager messager, Diagnostic.Kind diagnosticKind) {
        this.messager = messager;
        this.diagnosticKind = diagnosticKind;
        this.errorMessages = ResourceBundle.getBundle("org.hibernate.validator.ap.ValidationProcessorMessages");
    }

    public Messager getDelegate() {
        return this.messager;
    }

    public void reportErrors(Set<ConstraintCheckError> errors) {
        for (ConstraintCheckError oneError : errors) {
            this.reportError(oneError);
        }
    }

    private void reportError(ConstraintCheckError error) {
        String message = this.errorMessages.getString(error.getMessageKey());
        if (error.getMessageParameters() != null) {
            message = MessageFormat.format(message, error.getMessageParameters());
        }
        this.messager.printMessage(this.diagnosticKind, message, error.getElement(), error.getAnnotationMirror());
    }
}

