/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintDescriptor;
import javax.validation.ConstraintValidator;
import javax.validation.OverridesParameter;
import javax.validation.OverridesParameters;
import javax.validation.ReportAsSingleViolation;
import javax.validation.ValidationException;
import javax.validation.groups.Default;
import org.hibernate.validation.engine.BuiltinConstraints;
import org.hibernate.validation.util.LoggerFactory;
import org.hibernate.validation.util.ReflectionHelper;
import org.hibernate.validation.util.annotationfactory.AnnotationDescriptor;
import org.hibernate.validation.util.annotationfactory.AnnotationFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintDescriptorImpl<U extends Annotation>
implements ConstraintDescriptor {
    private static final Logger log = LoggerFactory.make();
    private static final Class<?>[] DEFAULT_GROUP = new Class[]{Default.class};
    private static final int OVERRIDES_PARAMETER_DEFAULT_INDEX = -1;
    private final U annotation;
    private final List<Class<? extends ConstraintValidator<?, ?>>> constraintClasses = new ArrayList();
    private final Set<Class<?>> groups;
    private final Map<String, Object> parameters;
    private final Set<ConstraintDescriptor> composingConstraints = new HashSet<ConstraintDescriptor>();
    private final Map<ClassIndexWrapper, Map<String, Object>> overrideParameters = new HashMap<ClassIndexWrapper, Map<String, Object>>();
    private final boolean isReportAsSingleInvalidConstraint;
    private final BuiltinConstraints builtinConstraints;

    public ConstraintDescriptorImpl(U annotation, Class<?>[] groups, BuiltinConstraints builtinConstraints) {
        this(annotation, new HashSet(), builtinConstraints);
        if (groups.length == 0) {
            groups = DEFAULT_GROUP;
        }
        this.groups.addAll(Arrays.asList(groups));
    }

    public ConstraintDescriptorImpl(U annotation, Set<Class<?>> groups, BuiltinConstraints builtinConstraints) {
        this.annotation = annotation;
        this.groups = groups;
        this.parameters = this.getAnnotationParameters((Annotation)annotation);
        this.builtinConstraints = builtinConstraints;
        this.isReportAsSingleInvalidConstraint = annotation.annotationType().isAnnotationPresent(ReportAsSingleViolation.class);
        this.findConstraintClasses();
        this.parseOverrideParameters();
        this.parseComposingConstraints();
    }

    private void findConstraintClasses() {
        if (ReflectionHelper.isBuiltInConstraintAnnotation(this.annotation)) {
            this.constraintClasses.addAll(this.builtinConstraints.getBuiltInConstraints((Annotation)this.annotation));
        } else {
            Constraint constraint = this.annotation.annotationType().getAnnotation(Constraint.class);
            this.constraintClasses.addAll(Arrays.asList(constraint.validatedBy()));
        }
    }

    public U getAnnotation() {
        return this.annotation;
    }

    public Set<Class<?>> getGroups() {
        return this.groups;
    }

    public List<Class<? extends ConstraintValidator<?, ?>>> getConstraintValidatorClasses() {
        return Collections.unmodifiableList(this.constraintClasses);
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Set<ConstraintDescriptor> getComposingConstraints() {
        return this.composingConstraints;
    }

    public boolean isReportAsSingleViolation() {
        return this.isReportAsSingleInvalidConstraint;
    }

    public String toString() {
        return "ConstraintDescriptorImpl{annotation=" + this.annotation + ", constraintClasses=" + this.constraintClasses.toString() + ", groups=" + this.groups + ", parameters=" + this.parameters + ", composingConstraints=" + this.composingConstraints + ", isReportAsSingleInvalidConstraint=" + this.isReportAsSingleInvalidConstraint + '}';
    }

    private Map<String, Object> getAnnotationParameters(Annotation annotation) {
        Method[] declaredMethods = annotation.annotationType().getDeclaredMethods();
        HashMap<String, Object> parameters = new HashMap<String, Object>(declaredMethods.length);
        for (Method m : declaredMethods) {
            try {
                parameters.put(m.getName(), m.invoke((Object)annotation, new Object[0]));
            }
            catch (IllegalAccessException e) {
                throw new ValidationException("Unable to read annotation parameters: " + annotation.getClass(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ValidationException("Unable to read annotation parameters: " + annotation.getClass(), (Throwable)e);
            }
        }
        return Collections.unmodifiableMap(parameters);
    }

    private void addOverrideParameter(Map<ClassIndexWrapper, Map<String, Object>> overrideParameters, Object value, OverridesParameter ... parameters) {
        for (OverridesParameter parameter : parameters) {
            ClassIndexWrapper wrapper = new ClassIndexWrapper(parameter.constraint(), parameter.index());
            Map<String, Object> map = overrideParameters.get(wrapper);
            if (map == null) {
                map = new HashMap<String, Object>();
                overrideParameters.put(wrapper, map);
            }
            map.put(parameter.parameter(), value);
        }
    }

    private Object getMethodValue(Annotation annotation, Method m) {
        Object value;
        try {
            value = m.invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new ValidationException("Unable to retrieve annotation parameter value.");
        }
        catch (InvocationTargetException e) {
            throw new ValidationException("Unable to retrieve annotation parameter value.");
        }
        return value;
    }

    private void parseOverrideParameters() {
        for (Method m : this.annotation.annotationType().getMethods()) {
            if (m.getAnnotation(OverridesParameter.class) != null) {
                this.addOverrideParameter(this.overrideParameters, this.getMethodValue((Annotation)this.annotation, m), m.getAnnotation(OverridesParameter.class));
                continue;
            }
            if (m.getAnnotation(OverridesParameters.class) == null) continue;
            this.addOverrideParameter(this.overrideParameters, this.getMethodValue((Annotation)this.annotation, m), m.getAnnotation(OverridesParameters.class).value());
        }
    }

    private void parseComposingConstraints() {
        for (Annotation declaredAnnotation : this.annotation.annotationType().getDeclaredAnnotations()) {
            if (ReflectionHelper.isConstraintAnnotation(declaredAnnotation) || ReflectionHelper.isBuiltInConstraintAnnotation(declaredAnnotation)) {
                ConstraintDescriptorImpl descriptor = this.createComposingConstraintDescriptor(-1, declaredAnnotation);
                this.composingConstraints.add(descriptor);
                log.debug("Adding composing constraint: " + descriptor);
                continue;
            }
            if (!ReflectionHelper.isMultiValueConstraint(declaredAnnotation)) continue;
            List<Annotation> multiValueConstraints = ReflectionHelper.getMultiValueConstraints(declaredAnnotation);
            int index = 1;
            for (Annotation constraintAnnotation : multiValueConstraints) {
                ConstraintDescriptorImpl descriptor = this.createComposingConstraintDescriptor(index, constraintAnnotation);
                this.composingConstraints.add(descriptor);
                log.debug("Adding composing constraint: " + descriptor);
                ++index;
            }
        }
    }

    private ConstraintDescriptorImpl createComposingConstraintDescriptor(int index, Annotation constraintAnnotation) {
        AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor(constraintAnnotation.annotationType(), this.getAnnotationParameters(constraintAnnotation));
        Map<String, Object> overrides = this.overrideParameters.get(new ClassIndexWrapper(constraintAnnotation.annotationType(), index));
        if (overrides != null) {
            for (Map.Entry<String, Object> entry : overrides.entrySet()) {
                annotationDescriptor.setValue(entry.getKey(), entry.getValue());
            }
        }
        Object annotationProxy = AnnotationFactory.create(annotationDescriptor);
        return new ConstraintDescriptorImpl(annotationProxy, this.groups, this.builtinConstraints);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassIndexWrapper {
        final Class<?> clazz;
        final int index;

        ClassIndexWrapper(Class<?> clazz, int index) {
            this.clazz = clazz;
            this.index = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassIndexWrapper that = (ClassIndexWrapper)o;
            if (this.index != that.index) {
                return false;
            }
            return !(this.clazz != null ? !this.clazz.equals(that.clazz) : that.clazz != null);
        }

        public int hashCode() {
            int result = this.clazz != null ? this.clazz.hashCode() : 0;
            result = 31 * result + this.index;
            return result;
        }
    }
}

