/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.ConstraintDescriptor;
import javax.validation.ConstraintValidatorContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintValidatorContextImpl
implements ConstraintValidatorContext {
    private final ConstraintDescriptor constraintDescriptor;
    private final List<ErrorMessage> errorMessages;
    private boolean defaultDisabled;

    public ConstraintValidatorContextImpl(ConstraintDescriptor constraintDescriptor) {
        this.constraintDescriptor = constraintDescriptor;
        this.errorMessages = new ArrayList<ErrorMessage>(3);
    }

    public void disableDefaultError() {
        this.defaultDisabled = true;
    }

    public String getDefaultErrorMessage() {
        return (String)this.constraintDescriptor.getParameters().get("message");
    }

    public void addError(String message) {
        this.errorMessages.add(new ErrorMessage(message, null));
    }

    public void addError(String message, String property) {
        this.errorMessages.add(new ErrorMessage(message, property));
    }

    public List<ErrorMessage> getErrorMessages() {
        ArrayList<ErrorMessage> returnedErrorMessages = new ArrayList<ErrorMessage>(this.errorMessages.size() + 1);
        Collections.copy(returnedErrorMessages, this.errorMessages);
        if (!this.defaultDisabled) {
            returnedErrorMessages.add(new ErrorMessage(this.getDefaultErrorMessage(), null));
        }
        return returnedErrorMessages;
    }

    public static class ErrorMessage {
        private final String message;
        private final String property;

        private ErrorMessage(String message, String property) {
            this.message = message;
            this.property = property;
        }

        public String getMessage() {
            return this.message;
        }

        public String getProperty() {
            return this.property;
        }
    }
}

