/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintDescriptor;
import javax.validation.PropertyDescriptor;
import org.hibernate.validation.engine.ConstraintDescriptorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementDescriptorImpl
implements PropertyDescriptor {
    private final Class<?> returnType;
    private final boolean cascaded;
    private final Set<ConstraintDescriptor> constraintDescriptors = new HashSet<ConstraintDescriptor>();
    private final String propertyPath;

    public ElementDescriptorImpl(Class<?> returnType, boolean cascaded, String propertyPath) {
        this.returnType = returnType;
        this.cascaded = cascaded;
        this.propertyPath = propertyPath;
    }

    public void addConstraintDescriptor(ConstraintDescriptorImpl constraintDescriptor) {
        this.constraintDescriptors.add(constraintDescriptor);
    }

    public boolean hasConstraints() {
        return this.constraintDescriptors.size() != 0;
    }

    public Class getType() {
        return this.returnType;
    }

    public boolean isCascaded() {
        return this.cascaded;
    }

    public Set<ConstraintDescriptor> getConstraintDescriptors() {
        return Collections.unmodifiableSet(this.constraintDescriptors);
    }

    public String getPropertyName() {
        return this.propertyPath;
    }
}

