/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import org.hibernate.validation.engine.ConstraintViolationImpl;
import org.hibernate.validation.util.IdentitySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionContext<T> {
    private final T rootBean;
    private final Map<Class<?>, IdentitySet> processedObjects;
    private final List<ConstraintViolationImpl<T>> failingConstraintViolations;
    private String propertyPath;
    private Class<?> currentGroup;
    private Stack<ValidatedBean> validatedObjectStack = new Stack();
    private final MessageInterpolator messageResolver;
    ConstraintValidatorFactory constraintValidatorFactory;

    public ExecutionContext(T object, MessageInterpolator messageResolver, ConstraintValidatorFactory constraintValidatorFactory) {
        this(object, object, messageResolver, constraintValidatorFactory);
    }

    public ExecutionContext(T rootBean, Object object, MessageInterpolator messageResolver, ConstraintValidatorFactory constraintValidatorFactory) {
        this.rootBean = rootBean;
        this.messageResolver = messageResolver;
        this.constraintValidatorFactory = constraintValidatorFactory;
        this.validatedObjectStack.push(new ValidatedBean(object));
        this.processedObjects = new HashMap();
        this.propertyPath = "";
        this.failingConstraintViolations = new ArrayList<ConstraintViolationImpl<T>>();
    }

    public MessageInterpolator getMessageResolver() {
        return this.messageResolver;
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory;
    }

    public Object peekValidatedObject() {
        return this.validatedObjectStack.peek().bean;
    }

    public Class<?> peekValidatedObjectType() {
        return this.validatedObjectStack.peek().beanType;
    }

    public void pushValidatedObject(Object validatedObject) {
        this.validatedObjectStack.push(new ValidatedBean(validatedObject));
    }

    public void popValidatedObject() {
        this.validatedObjectStack.pop();
    }

    public T getRootBean() {
        return this.rootBean;
    }

    public Class<?> getCurrentGroup() {
        return this.currentGroup;
    }

    public void setCurrentGroup(Class<?> currentGroup) {
        this.currentGroup = currentGroup;
    }

    public void markProcessedForCurrentGroup() {
        if (this.processedObjects.containsKey(this.currentGroup)) {
            this.processedObjects.get(this.currentGroup).add(this.validatedObjectStack.peek().bean);
        } else {
            IdentitySet set = new IdentitySet();
            set.add(this.validatedObjectStack.peek().bean);
            this.processedObjects.put(this.currentGroup, set);
        }
    }

    public boolean isProcessedForCurrentGroup(Object value) {
        IdentitySet objectsProcessedInCurrentGroups = this.processedObjects.get(this.currentGroup);
        return objectsProcessedInCurrentGroups != null && objectsProcessedInCurrentGroups.contains(value);
    }

    public void addConstraintFailure(ConstraintViolationImpl<T> failingConstraintViolation) {
        int i = this.failingConstraintViolations.indexOf(failingConstraintViolation);
        if (i == -1) {
            this.failingConstraintViolations.add(failingConstraintViolation);
        } else {
            this.failingConstraintViolations.get(i).addGroups(failingConstraintViolation.getGroups());
        }
    }

    public List<ConstraintViolationImpl<T>> getFailingConstraints() {
        return this.failingConstraintViolations;
    }

    public void clearFailingConstraints() {
        this.failingConstraintViolations.clear();
    }

    public void pushProperty(String property) {
        this.propertyPath = this.propertyPath.length() == 0 ? property : this.propertyPath + "." + property;
    }

    public void popProperty() {
        int lastIndex = this.propertyPath.lastIndexOf(46);
        this.propertyPath = lastIndex != -1 ? this.propertyPath.substring(0, lastIndex) : "";
    }

    public void appendIndexToPropertyPath(String index) {
        this.propertyPath = this.propertyPath + index;
    }

    public void replacePropertyIndex(String index) {
        this.propertyPath = this.propertyPath.replaceAll("\\{0\\}", index);
    }

    public String peekPropertyPath() {
        return this.propertyPath;
    }

    public boolean needsValidation(Set<Class<?>> groups) {
        return groups.contains(this.currentGroup);
    }

    private static class ValidatedBean {
        final Object bean;
        final Class<?> beanType;

        private ValidatedBean(Object bean) {
            this.bean = bean;
            this.beanType = bean == null ? null : bean.getClass();
        }
    }
}

