/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.ConstraintDescriptor;
import javax.validation.MessageInterpolator;
import org.hibernate.validation.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBundleMessageInterpolator
implements MessageInterpolator {
    private static final String DEFAULT_VALIDATION_MESSAGES = "org.hibernate.validation.ValidationMessages";
    private static final String USER_VALIDATION_MESSAGES = "ValidationMessages";
    private static final Logger log = LoggerFactory.make();
    private static final Pattern messagePattern = Pattern.compile("\\{([\\w\\.]+)\\}");
    private final Locale defaultLocale;
    private final Map<Locale, ResourceBundle> userBundlesMap = new HashMap<Locale, ResourceBundle>();
    private final Map<Locale, ResourceBundle> defaultBundlesMap = new HashMap<Locale, ResourceBundle>();

    public ResourceBundleMessageInterpolator() {
        this(null);
    }

    public ResourceBundleMessageInterpolator(ResourceBundle resourceBundle) {
        this.defaultLocale = Locale.getDefault();
        if (resourceBundle == null) {
            ResourceBundle bundle = this.getFileBasedResourceBundle(this.defaultLocale);
            this.userBundlesMap.put(this.defaultLocale, bundle);
        } else {
            this.userBundlesMap.put(this.defaultLocale, resourceBundle);
        }
        this.defaultBundlesMap.put(this.defaultLocale, ResourceBundle.getBundle(DEFAULT_VALIDATION_MESSAGES, this.defaultLocale));
    }

    public String interpolate(String message, ConstraintDescriptor constraintDescriptor, Object value) {
        return this.replace(message, constraintDescriptor.getParameters(), this.defaultLocale);
    }

    public String interpolate(String message, ConstraintDescriptor constraintDescriptor, Object value, Locale locale) {
        return this.replace(message, constraintDescriptor.getParameters(), locale);
    }

    private ResourceBundle getFileBasedResourceBundle(Locale locale) {
        ResourceBundle rb = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            rb = this.loadBundle(classLoader, locale, "ValidationMessages not found by thread local classloader");
        }
        if (rb == null) {
            rb = this.loadBundle(this.getClass().getClassLoader(), locale, "ValidationMessages not found by validator classloader");
        }
        if (log.isDebugEnabled()) {
            if (rb != null) {
                log.debug("ValidationMessages found");
            } else {
                log.debug("ValidationMessages not found. Delegating to org.hibernate.validation.ValidationMessages");
            }
        }
        return rb;
    }

    private ResourceBundle loadBundle(ClassLoader classLoader, Locale locale, String message) {
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle(USER_VALIDATION_MESSAGES, locale, classLoader);
        }
        catch (MissingResourceException e) {
            log.trace(message);
        }
        return rb;
    }

    private String replace(String message, Map<String, Object> parameters, Locale locale) {
        Matcher matcher = messagePattern.matcher(message);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, this.resolveParameter(matcher.group(1), parameters, locale));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String resolveParameter(String token, Map<String, Object> parameters, Locale locale) {
        Object variable = parameters.get(token);
        if (variable != null) {
            return variable.toString();
        }
        ResourceBundle userResourceBundle = this.findUserResourceBundle(locale);
        ResourceBundle defaultResourceBundle = this.findDefaultResourceBundle(locale);
        StringBuffer buffer = new StringBuffer();
        String string = null;
        try {
            string = userResourceBundle != null ? userResourceBundle.getString(token) : null;
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (string == null) {
            try {
                string = defaultResourceBundle.getString(token);
            }
            catch (MissingResourceException e) {
                buffer.append("{").append(token).append('}');
            }
        }
        if (string != null) {
            buffer.append(this.replace(string, parameters, locale));
        }
        return buffer.toString();
    }

    private ResourceBundle findDefaultResourceBundle(Locale locale) {
        if (this.defaultBundlesMap.containsKey(locale)) {
            return this.defaultBundlesMap.get(locale);
        }
        ResourceBundle bundle = ResourceBundle.getBundle(DEFAULT_VALIDATION_MESSAGES, locale);
        this.defaultBundlesMap.put(locale, bundle);
        return bundle;
    }

    private ResourceBundle findUserResourceBundle(Locale locale) {
        if (this.userBundlesMap.containsKey(locale)) {
            return this.userBundlesMap.get(locale);
        }
        ResourceBundle bundle = this.getFileBasedResourceBundle(locale);
        this.userBundlesMap.put(locale, bundle);
        return bundle;
    }
}

