/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import javax.validation.spi.ConfigurationState;
import org.hibernate.validation.engine.BuiltinConstraints;
import org.hibernate.validation.engine.ValidatorContextImpl;

public class ValidatorFactoryImpl
implements ValidatorFactory {
    private final MessageInterpolator messageInterpolator;
    private final TraversableResolver traversableResolver;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final BuiltinConstraints builtinConstraints = new BuiltinConstraints();

    public ValidatorFactoryImpl(ConfigurationState configurationState) {
        this.messageInterpolator = configurationState.getMessageInterpolator();
        this.constraintValidatorFactory = configurationState.getConstraintValidatorFactory();
        this.traversableResolver = configurationState.getTraversableResolver();
    }

    public Validator getValidator() {
        return this.usingContext().getValidator();
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    public ValidatorContext usingContext() {
        return new ValidatorContextImpl(this.constraintValidatorFactory, this.messageInterpolator, this.traversableResolver, this.builtinConstraints);
    }
}

