/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.BeanDescriptor;
import javax.validation.ConstraintDescriptor;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Validator;
import javax.validation.groups.Default;
import org.hibernate.validation.engine.BeanMetaDataImpl;
import org.hibernate.validation.engine.BuiltinConstraints;
import org.hibernate.validation.engine.ConstraintViolationImpl;
import org.hibernate.validation.engine.ExecutionContext;
import org.hibernate.validation.engine.MetaConstraint;
import org.hibernate.validation.util.PropertyIterator;
import org.hibernate.validation.util.ReflectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorImpl
implements Validator {
    private static final Set<Class<?>> INDEXABLE_CLASS = new HashSet();
    private static final Class<?>[] DEFAULT_GROUP = new Class[]{Default.class};
    private static Map<Class<?>, BeanMetaDataImpl<?>> metadataProviders = new ConcurrentHashMap(10);
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final MessageInterpolator messageInterpolator;
    private final BuiltinConstraints builtinConstraints;

    public ValidatorImpl(ConstraintValidatorFactory constraintValidatorFactory, MessageInterpolator messageInterpolator, BuiltinConstraints builtinConstraints) {
        this.constraintValidatorFactory = constraintValidatorFactory;
        this.messageInterpolator = messageInterpolator;
        this.builtinConstraints = builtinConstraints;
    }

    public <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
        if (object == null) {
            throw new IllegalArgumentException("Validation of a null object");
        }
        ExecutionContext<T> context = new ExecutionContext<T>(object, this.messageInterpolator, this.constraintValidatorFactory);
        List<ConstraintViolationImpl<T>> list = this.validateInContext(context, Arrays.asList(groups));
        return new HashSet<ConstraintViolation<T>>(list);
    }

    private <T> List<ConstraintViolationImpl<T>> validateInContext(ExecutionContext<T> context, List<Class<?>> groups) {
        if (context.peekValidatedObject() == null) {
            return Collections.emptyList();
        }
        if (groups.size() == 0) {
            groups = Arrays.asList(DEFAULT_GROUP);
        }
        block0: for (Class<?> group : groups) {
            ArrayList expandedGroups = new ArrayList();
            boolean isGroupSequence = this.expandGroup(context.peekValidatedObjectType(), group, expandedGroups);
            for (Class clazz : expandedGroups) {
                context.setCurrentGroup(clazz);
                this.validateConstraints(context);
                this.validateCascadedConstraints(context);
                if (!isGroupSequence || context.getFailingConstraints().size() <= 0) continue;
                continue block0;
            }
        }
        return context.getFailingConstraints();
    }

    private <T> void validateConstraints(ExecutionContext<T> executionContext) {
        BeanMetaDataImpl<?> beanMetaData = this.getBeanMetaData(executionContext.peekValidatedObjectType());
        for (MetaConstraint metaConstraint : beanMetaData.geMetaConstraintList()) {
            ConstraintDescriptor mainConstraintDescriptor = metaConstraint.getDescriptor();
            executionContext.pushProperty(metaConstraint.getPropertyName());
            if (!executionContext.needsValidation(mainConstraintDescriptor.getGroups())) {
                executionContext.popProperty();
                continue;
            }
            metaConstraint.validateConstraint(beanMetaData.getBeanClass(), executionContext);
            executionContext.popProperty();
        }
        executionContext.markProcessedForCurrentGroup();
    }

    private <T> void validateCascadedConstraints(ExecutionContext<T> context) {
        List<Member> cascadedMembers = this.getBeanMetaData(context.peekValidatedObjectType()).getCascadedMembers();
        for (Member member : cascadedMembers) {
            Type type = ReflectionHelper.typeOf(member);
            context.pushProperty(ReflectionHelper.getPropertyName(member));
            Object value = ReflectionHelper.getValue(member, context.peekValidatedObject());
            if (value == null) continue;
            Iterator<?> iter = this.createIteratorForCascadedValue(context, type, value);
            this.validateCascadedConstraint(context, iter);
            context.popProperty();
        }
    }

    private <T> Iterator<?> createIteratorForCascadedValue(ExecutionContext<T> context, Type type, Object value) {
        Iterator<Object> iter;
        if (ReflectionHelper.isCollection(type)) {
            boolean isIterable = value instanceof Iterable;
            Map map = !isIterable ? (Map)value : null;
            Set elements = isIterable ? (Set)value : map.entrySet();
            iter = elements.iterator();
            context.appendIndexToPropertyPath("[{0}]");
        } else if (ReflectionHelper.isArray(type)) {
            List<Object> arrayList = Arrays.asList(value);
            iter = arrayList.iterator();
            context.appendIndexToPropertyPath("[{0}]");
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(value);
            iter = list.iterator();
        }
        return iter;
    }

    private <T> void validateCascadedConstraint(ExecutionContext<T> context, Iterator<?> iter) {
        int i = 0;
        while (iter.hasNext()) {
            Object actualValue = iter.next();
            String propertyIndex = String.valueOf(i);
            if (actualValue instanceof Map.Entry) {
                Object key = ((Map.Entry)actualValue).getKey();
                if (INDEXABLE_CLASS.contains(key.getClass())) {
                    propertyIndex = key.toString();
                }
                actualValue = ((Map.Entry)actualValue).getValue();
            }
            if (context.isProcessedForCurrentGroup(actualValue)) {
                ++i;
                continue;
            }
            context.replacePropertyIndex(propertyIndex);
            context.pushValidatedObject(actualValue);
            this.validateInContext(context, Arrays.asList(context.getCurrentGroup()));
            context.popValidatedObject();
            ++i;
        }
    }

    public <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?> ... groups) {
        ArrayList<ConstraintViolationImpl<T>> failingConstraintViolations = new ArrayList<ConstraintViolationImpl<T>>();
        this.validateProperty(object, new PropertyIterator(propertyName), failingConstraintViolations, groups);
        return new HashSet<ConstraintViolation<T>>(failingConstraintViolations);
    }

    private <T> void validateProperty(T object, PropertyIterator propertyIter, List<ConstraintViolationImpl<T>> failingConstraintViolations, Class<?> ... groups) {
        if (object == null) {
            throw new IllegalArgumentException("Validated object cannot be null");
        }
        Class<?> beanType = object.getClass();
        HashSet<MetaConstraint> metaConstraints = new HashSet<MetaConstraint>();
        this.getMetaConstraintsForPath(beanType, propertyIter, metaConstraints);
        if (metaConstraints.size() == 0) {
            return;
        }
        if (groups.length == 0) {
            groups = DEFAULT_GROUP;
        }
        block0: for (Class<?> group : groups) {
            ArrayList expandedGroups = new ArrayList();
            boolean isGroupSequence = this.expandGroup(beanType, group, expandedGroups);
            for (Class clazz : expandedGroups) {
                for (MetaConstraint metaConstraint : metaConstraints) {
                    if (!metaConstraint.getDescriptor().getGroups().contains(clazz)) continue;
                    ExecutionContext<T> context = new ExecutionContext<T>(object, this.messageInterpolator, this.constraintValidatorFactory);
                    metaConstraint.validateConstraint(object.getClass(), context);
                    failingConstraintViolations.addAll(context.getFailingConstraints());
                }
                if (!isGroupSequence || failingConstraintViolations.size() <= 0) continue;
                continue block0;
            }
        }
    }

    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
        ArrayList<ConstraintViolationImpl<T>> failingConstraintViolations = new ArrayList<ConstraintViolationImpl<T>>();
        this.validateValue(beanType, value, new PropertyIterator(propertyName), failingConstraintViolations, groups);
        return new HashSet<ConstraintViolation<T>>(failingConstraintViolations);
    }

    public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        return this.getBeanMetaData(clazz).getBeanDescriptor();
    }

    private <T> void validateValue(Class<T> beanType, Object value, PropertyIterator propertyIter, List<ConstraintViolationImpl<T>> failingConstraintViolations, Class<?> ... groups) {
        HashSet<MetaConstraint> metaConstraints = new HashSet<MetaConstraint>();
        this.getMetaConstraintsForPath(beanType, propertyIter, metaConstraints);
        if (metaConstraints.size() == 0) {
            return;
        }
        if (groups.length == 0) {
            groups = DEFAULT_GROUP;
        }
        block0: for (Class<?> group : groups) {
            ArrayList expandedGroups = new ArrayList();
            boolean isGroupSequence = this.expandGroup(beanType, group, expandedGroups);
            for (Class clazz : expandedGroups) {
                for (MetaConstraint metaConstraint : metaConstraints) {
                    if (!metaConstraint.getDescriptor().getGroups().contains(clazz)) continue;
                    ExecutionContext<Object> context = new ExecutionContext<Object>(value, this.messageInterpolator, this.constraintValidatorFactory);
                    context.pushProperty(propertyIter.getOriginalProperty());
                    metaConstraint.validateConstraint(beanType, value, context);
                    failingConstraintViolations.addAll(context.getFailingConstraints());
                }
                if (!isGroupSequence || failingConstraintViolations.size() <= 0) continue;
                continue block0;
            }
        }
    }

    private void getMetaConstraintsForPath(Class<?> clazz, PropertyIterator propertyIter, Set<MetaConstraint> metaConstraints) {
        propertyIter.split();
        if (!propertyIter.hasNext()) {
            List<MetaConstraint> metaConstraintList = this.getBeanMetaData(clazz).geMetaConstraintList();
            for (MetaConstraint metaConstraint : metaConstraintList) {
                if (!metaConstraint.getPropertyName().equals(propertyIter.getHead())) continue;
                metaConstraints.add(metaConstraint);
            }
        } else {
            List<Member> cascadedMembers = this.getBeanMetaData(clazz).getCascadedMembers();
            for (Member m : cascadedMembers) {
                if (!ReflectionHelper.getPropertyName(m).equals(propertyIter.getHead())) continue;
                Type type = ReflectionHelper.typeOf(m);
                if (propertyIter.isIndexed() && (type = ReflectionHelper.getIndexedType(type)) == null) continue;
                this.getMetaConstraintsForPath((Class)type, propertyIter, metaConstraints);
            }
        }
    }

    private <T> boolean expandGroup(Class<T> beanType, Class<?> group, List<Class<?>> expandedGroups) {
        boolean isGroupSequence;
        if (expandedGroups == null) {
            throw new IllegalArgumentException("List cannot be empty");
        }
        BeanMetaDataImpl<T> metaDataProvider = this.getBeanMetaData(beanType);
        if (metaDataProvider.getGroupSequences().containsKey(group)) {
            expandedGroups.addAll((Collection)metaDataProvider.getGroupSequences().get(group));
            isGroupSequence = true;
        } else {
            expandedGroups.add(group);
            isGroupSequence = false;
        }
        return isGroupSequence;
    }

    private <T> BeanMetaDataImpl<T> getBeanMetaData(Class<T> beanClass) {
        if (beanClass == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        BeanMetaDataImpl<Object> metadata = metadataProviders.get(beanClass);
        if (metadata == null) {
            metadata = new BeanMetaDataImpl<T>(beanClass, this.builtinConstraints);
            metadataProviders.put(beanClass, metadata);
        }
        return metadata;
    }

    static {
        INDEXABLE_CLASS.add(Integer.class);
        INDEXABLE_CLASS.add(Long.class);
        INDEXABLE_CLASS.add(String.class);
    }
}

