/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.util;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.validation.Constraint;
import javax.validation.ValidationException;
import org.hibernate.validation.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionHelper {
    private static final Logger log = LoggerFactory.make();

    private ReflectionHelper() {
    }

    public static boolean isBuiltInConstraintAnnotation(Annotation annotation) {
        boolean isBuiltInConstraintAnnotation = false;
        String packageName = annotation.annotationType().getPackage().getName();
        if ("javax.validation.constraints".equals(packageName)) {
            isBuiltInConstraintAnnotation = true;
        }
        return isBuiltInConstraintAnnotation;
    }

    public static boolean isConstraintAnnotation(Annotation annotation) {
        Method[] methods;
        Constraint constraint = annotation.annotationType().getAnnotation(Constraint.class);
        if (constraint == null) {
            return false;
        }
        try {
            ReflectionHelper.getAnnotationParameter(annotation, "message", String.class);
        }
        catch (Exception e) {
            String msg = annotation.annotationType().getName() + " contains Constraint annotation, but does " + "not contain a message parameter. Annotation is getting ignored.";
            log.warn(msg);
            return false;
        }
        try {
            ReflectionHelper.getAnnotationParameter(annotation, "groups", Class[].class);
        }
        catch (Exception e) {
            String msg = annotation.annotationType().getName() + " contains Constraint annotation, but does " + "not contain a groups parameter. Annotation is getting ignored.";
            log.warn(msg);
            return false;
        }
        for (Method m : methods = annotation.getClass().getMethods()) {
            if (!m.getName().startsWith("valid")) continue;
            String msg = "Parameters starting with 'valid' are not allowed in a constraint.";
            log.warn(msg);
            return false;
        }
        return true;
    }

    public static boolean isMultiValueConstraint(Annotation annotation) {
        boolean isMultiValueConstraint;
        block6: {
            isMultiValueConstraint = false;
            try {
                Annotation[] annotations;
                Method m = annotation.getClass().getMethod("value", new Class[0]);
                Class<?> returnType = m.getReturnType();
                if (!returnType.isArray() || !returnType.getComponentType().isAnnotation()) break block6;
                for (Annotation a : annotations = (Annotation[])m.invoke((Object)annotation, new Object[0])) {
                    if (!ReflectionHelper.isConstraintAnnotation(a) && !ReflectionHelper.isBuiltInConstraintAnnotation(a)) {
                        isMultiValueConstraint = false;
                        break;
                    }
                    isMultiValueConstraint = true;
                }
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (IllegalAccessException iae) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return isMultiValueConstraint;
    }

    public static <A extends Annotation> List<Annotation> getMultiValueConstraints(A annotation) {
        ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
        try {
            Method m = annotation.getClass().getMethod("value", new Class[0]);
            Class<?> returnType = m.getReturnType();
            if (returnType.isArray() && returnType.getComponentType().isAnnotation()) {
                Annotation[] annotations;
                for (Annotation a : annotations = (Annotation[])m.invoke(annotation, new Object[0])) {
                    if (!ReflectionHelper.isConstraintAnnotation(a) && !ReflectionHelper.isBuiltInConstraintAnnotation(a)) continue;
                    annotationList.add(a);
                }
            }
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return annotationList;
    }

    public static <T> T getAnnotationParameter(Annotation annotation, String parameterName, Class<T> type) {
        try {
            Method m = annotation.getClass().getMethod(parameterName, new Class[0]);
            Object o = m.invoke((Object)annotation, new Object[0]);
            if (o.getClass().getName().equals(type.getName())) {
                return (T)o;
            }
            String msg = "Wrong parameter type. Expected: " + type.getName() + " Actual: " + o.getClass().getName();
            throw new ValidationException(msg);
        }
        catch (NoSuchMethodException e) {
            String msg = "The specified annotation defines no parameter '" + parameterName + "'.";
            throw new ValidationException(msg, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            String msg = "Unable to get '" + parameterName + "' from " + annotation.getClass().getName();
            throw new ValidationException(msg, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            String msg = "Unable to get '" + parameterName + "' from " + annotation.getClass().getName();
            throw new ValidationException(msg, (Throwable)e);
        }
    }

    public static String getPropertyName(Member member) {
        String name = null;
        if (member instanceof Field) {
            name = member.getName();
        }
        if (member instanceof Method) {
            String methodName = member.getName();
            if (methodName.startsWith("is")) {
                name = Introspector.decapitalize(methodName.substring(2));
            } else if (methodName.startsWith("get")) {
                name = Introspector.decapitalize(methodName.substring(3));
            }
        }
        return name;
    }

    public static Type typeOf(Member member) {
        if (member instanceof Field) {
            return ((Field)member).getGenericType();
        }
        if (member instanceof Method) {
            return ((Method)member).getGenericReturnType();
        }
        throw new IllegalArgumentException("Member " + member + " is neither a field nor a method");
    }

    public static Object getValue(Member member, Object object) {
        Object value = null;
        if (member instanceof Method) {
            Method method = (Method)member;
            try {
                value = method.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new ValidationException("Unable to access " + method.getName(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ValidationException("Unable to access " + method.getName(), (Throwable)e);
            }
        }
        if (member instanceof Field) {
            Field field = (Field)member;
            try {
                value = field.get(object);
            }
            catch (IllegalAccessException e) {
                throw new ValidationException("Unable to access " + field.getName(), (Throwable)e);
            }
        }
        return value;
    }

    public static void setAccessibility(Member member) {
        if (!Modifier.isPublic(member.getModifiers())) {
            ((AccessibleObject)((Object)member)).setAccessible(true);
        }
    }

    public static Class<?> loadClass(String name, Class caller) throws ClassNotFoundException {
        block3: {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader != null) {
                    return loader.loadClass(name);
                }
            }
            catch (ClassNotFoundException e) {
                if (caller != null) break block3;
                throw e;
            }
        }
        return Class.forName(name, true, caller.getClassLoader());
    }

    public static Type getIndexedType(Type type) {
        Type indexedType = null;
        if (ReflectionHelper.isCollection(type) && type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Class<? extends Collection> collectionClass = ReflectionHelper.getCollectionClass(type);
            if (collectionClass == Collection.class || collectionClass == List.class || collectionClass == Set.class || collectionClass == SortedSet.class) {
                indexedType = paramType.getActualTypeArguments()[0];
            } else if (collectionClass == Map.class || collectionClass == SortedMap.class) {
                indexedType = paramType.getActualTypeArguments()[1];
            }
        } else if (ReflectionHelper.isArray(type) && type instanceof GenericArrayType) {
            GenericArrayType arrayTye = (GenericArrayType)type;
            indexedType = arrayTye.getGenericComponentType();
        }
        return indexedType;
    }

    public static boolean isArray(Type type) {
        if (type instanceof Class) {
            return ((Class)type).isArray();
        }
        return type instanceof GenericArrayType;
    }

    public static boolean isCollection(Type type) {
        return ReflectionHelper.getCollectionClass(type) != null;
    }

    public static Class<? extends Collection> getCollectionClass(Type type) {
        if (type instanceof Class && ReflectionHelper.isCollectionClass((Class)type)) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionHelper.getCollectionClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            if (upperBounds.length == 0) {
                return null;
            }
            return ReflectionHelper.getCollectionClass(upperBounds[0]);
        }
        return null;
    }

    private static boolean isCollectionClass(Class<?> clazz) {
        Class<?>[] interfaces;
        for (Class<?> interfaceClass : interfaces = clazz.getInterfaces()) {
            if (interfaceClass != Collection.class && interfaceClass != List.class && interfaceClass != Set.class && interfaceClass != Map.class && interfaceClass != SortedSet.class && interfaceClass != SortedMap.class) continue;
            return true;
        }
        return false;
    }

    public static Object getIndexedValue(Object value, String index) {
        if (value == null) {
            return null;
        }
        int numIndex = -1;
        try {
            numIndex = Integer.valueOf(index);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if (numIndex == -1) {
            Map map = (Map)value;
            return map.get(index);
        }
        Iterator<Object> iter = null;
        Class<?> type = value.getClass();
        if (ReflectionHelper.isCollection(type)) {
            boolean isIterable = value instanceof Iterable;
            Map map = !isIterable ? (Map)value : null;
            Collection elements = isIterable ? (Collection)value : map.values();
            iter = elements.iterator();
        } else if (ReflectionHelper.isArray(type)) {
            List<Object> arrayList = Arrays.asList(value);
            iter = arrayList.iterator();
        }
        int i = 0;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (i == numIndex) {
                return o;
            }
            ++i;
        }
        return null;
    }
}

