/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintValidator;
import javax.validation.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorTypeHelper {
    private static final int VALIDATOR_TYPE_INDEX = 1;

    public static Map<Class<?>, Class<? extends ConstraintValidator<? extends Annotation, ?>>> getValidatorsTypes(List<Class<? extends ConstraintValidator<?, ?>>> validators) {
        if (validators == null || validators.size() == 0) {
            throw new ValidationException("No ConstraintValidators associated to @Constraint");
        }
        HashMap validatorsTypes = new HashMap();
        for (Class<ConstraintValidator<?, ?>> clazz : validators) {
            validatorsTypes.put(ValidatorTypeHelper.extractType(clazz), clazz);
        }
        return validatorsTypes;
    }

    private static Class<?> extractType(Class<? extends ConstraintValidator<?, ?>> validator) {
        HashMap<Type, Type> resolvedTypes = new HashMap<Type, Type>();
        Type constraintValidatorType = ValidatorTypeHelper.resolveTypes(resolvedTypes, validator);
        Object validatorType = ((ParameterizedType)constraintValidatorType).getActualTypeArguments()[1];
        if (validatorType == null) {
            throw new ValidationException("Null is an invalid type for a constraint validator.");
        }
        if (validatorType instanceof GenericArrayType) {
            validatorType = Array.class;
        }
        while (resolvedTypes.containsKey(validatorType)) {
            validatorType = (Type)resolvedTypes.get(validatorType);
        }
        return (Class)validatorType;
    }

    private static Type resolveTypes(Map<Type, Type> resolvedTypes, Type type) {
        block8: {
            block7: {
                if (type == null) {
                    return null;
                }
                if (!(type instanceof Class)) break block7;
                Class clazz = (Class)type;
                Type returnedType = ValidatorTypeHelper.resolveTypes(resolvedTypes, clazz.getGenericSuperclass());
                if (returnedType != null) {
                    return returnedType;
                }
                for (Type genericInterface : clazz.getGenericInterfaces()) {
                    returnedType = ValidatorTypeHelper.resolveTypes(resolvedTypes, genericInterface);
                    if (returnedType == null) continue;
                    return returnedType;
                }
                break block8;
            }
            if (!(type instanceof ParameterizedType)) break block8;
            ParameterizedType paramType = (ParameterizedType)type;
            if (!(paramType.getRawType() instanceof Class)) {
                return null;
            }
            Class rawType = (Class)paramType.getRawType();
            TypeVariable<Class<T>>[] originalTypes = rawType.getTypeParameters();
            Type[] partiallyResolvedTypes = paramType.getActualTypeArguments();
            int nbrOfParams = originalTypes.length;
            for (int i = 0; i < nbrOfParams; ++i) {
                resolvedTypes.put(originalTypes[i], partiallyResolvedTypes[i]);
            }
            if (rawType.equals(ConstraintValidator.class)) {
                return type;
            }
            ValidatorTypeHelper.resolveTypes(resolvedTypes, rawType.getGenericSuperclass());
            for (Type genericInterface : rawType.getGenericInterfaces()) {
                ValidatorTypeHelper.resolveTypes(resolvedTypes, genericInterface);
            }
        }
        return null;
    }
}

