/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.testutil;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Locale;
import javax.validation.Configuration;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstructorDescriptor;
import javax.validation.metadata.MethodDescriptor;
import javax.validation.metadata.ParameterDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import javax.validation.spi.ValidationProvider;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.testutil.DummyTraversableResolver;
import org.hibernate.validator.testutil.ValidationInvocationHandler;

public final class ValidatorUtil {
    private ValidatorUtil() {
    }

    public static Validator getValidator() {
        Configuration<HibernateValidatorConfiguration> configuration = ValidatorUtil.getConfiguration();
        configuration.traversableResolver((TraversableResolver)new DummyTraversableResolver());
        return configuration.buildValidatorFactory().getValidator();
    }

    public static Configuration<HibernateValidatorConfiguration> getConfiguration() {
        return ValidatorUtil.getConfiguration(HibernateValidator.class, Locale.ENGLISH);
    }

    public static Configuration<HibernateValidatorConfiguration> getConfiguration(Locale locale) {
        return ValidatorUtil.getConfiguration(HibernateValidator.class, locale);
    }

    public static <T extends Configuration<T>, U extends ValidationProvider<T>> T getConfiguration(Class<U> type) {
        return ValidatorUtil.getConfiguration(type, Locale.ENGLISH);
    }

    public static <T extends Configuration<T>, U extends ValidationProvider<T>> T getConfiguration(Class<U> type, Locale locale) {
        Locale.setDefault(locale);
        return (T)Validation.byProvider(type).configure();
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String property) {
        return ValidatorUtil.getValidator().getConstraintsForClass(clazz).getConstraintsForProperty(property);
    }

    public static BeanDescriptor getBeanDescriptor(Class<?> clazz) {
        return ValidatorUtil.getValidator().getConstraintsForClass(clazz);
    }

    public static MethodDescriptor getMethodDescriptor(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ValidatorUtil.getBeanDescriptor(clazz).getConstraintsForMethod(methodName, (Class[])parameterTypes);
    }

    public static ConstructorDescriptor getConstructorDescriptor(Class<?> clazz, Class<?> ... parameterTypes) {
        return ValidatorUtil.getBeanDescriptor(clazz).getConstraintsForConstructor((Class[])parameterTypes);
    }

    public static ParameterDescriptor getParameterDescriptor(Class<?> clazz, String methodName, Class<?>[] parameterTypes, int parameterIndex) {
        MethodDescriptor methodDescriptor = ValidatorUtil.getMethodDescriptor(clazz, methodName, parameterTypes);
        Contracts.assertNotNull((Object)methodDescriptor, (String)("No method with the given signature is declared in " + clazz + " or its super class"));
        return (ParameterDescriptor)methodDescriptor.getParameterDescriptors().get(parameterIndex);
    }

    public static <T, I extends T> T getValidatingProxy(I implementor, Validator methodValidator, Class<?> ... validationGroups) {
        ValidationInvocationHandler handler = new ValidationInvocationHandler(implementor, methodValidator, validationGroups);
        return (T)Proxy.newProxyInstance(implementor.getClass().getClassLoader(), implementor.getClass().getInterfaces(), (InvocationHandler)handler);
    }
}

