/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.cfg.context;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.internal.cfg.context.ConfiguredConstraint;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptions;
import org.hibernate.validator.internal.metadata.location.BeanConstraintLocation;
import org.hibernate.validator.internal.metadata.location.MethodConstraintLocation;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.spi.group.DefaultGroupSequenceProvider;

public class ConstraintMappingContext {
    private final Map<Class<?>, Set<ConfiguredConstraint<?, BeanConstraintLocation>>> constraintConfig = CollectionHelper.newHashMap();
    private final Map<Class<?>, Set<ConfiguredConstraint<?, MethodConstraintLocation>>> methodConstraintConfig = CollectionHelper.newHashMap();
    private final Map<Class<?>, Set<BeanConstraintLocation>> cascadeConfig = CollectionHelper.newHashMap();
    private final Map<Class<?>, Set<MethodConstraintLocation>> methodCascadeConfig = CollectionHelper.newHashMap();
    private final Set<Class<?>> configuredClasses = CollectionHelper.newHashSet();
    private final Map<Class<?>, List<Class<?>>> defaultGroupSequences = CollectionHelper.newHashMap();
    private final Map<Class<?>, Class<? extends org.hibernate.validator.group.DefaultGroupSequenceProvider<?>>> deprecatedDefaultGroupSequenceProviders = CollectionHelper.newHashMap();
    private final Map<Class<?>, Class<? extends DefaultGroupSequenceProvider<?>>> defaultGroupSequenceProviders = CollectionHelper.newHashMap();
    private final AnnotationProcessingOptions annotationProcessingOptions = new AnnotationProcessingOptions();

    public final Map<Class<?>, Set<ConfiguredConstraint<?, BeanConstraintLocation>>> getConstraintConfig() {
        return this.constraintConfig;
    }

    public Map<Class<?>, Set<ConfiguredConstraint<?, MethodConstraintLocation>>> getMethodConstraintConfig() {
        return this.methodConstraintConfig;
    }

    public final Map<Class<?>, Set<BeanConstraintLocation>> getCascadeConfig() {
        return this.cascadeConfig;
    }

    public final Map<Class<?>, Set<MethodConstraintLocation>> getMethodCascadeConfig() {
        return this.methodCascadeConfig;
    }

    public final Collection<Class<?>> getConfiguredClasses() {
        return this.configuredClasses;
    }

    public final List<Class<?>> getDefaultSequence(Class<?> beanType) {
        return this.defaultGroupSequences.get(beanType);
    }

    public final AnnotationProcessingOptions getAnnotationProcessingOptions() {
        return this.annotationProcessingOptions;
    }

    public final <T> Class<? extends org.hibernate.validator.group.DefaultGroupSequenceProvider<? super T>> getDeprecatedDefaultGroupSequenceProvider(Class<T> beanType) {
        Class<? extends org.hibernate.validator.group.DefaultGroupSequenceProvider<?>> providerClass = this.deprecatedDefaultGroupSequenceProviders.get(beanType);
        return providerClass;
    }

    public final <T> Class<? extends DefaultGroupSequenceProvider<? super T>> getDefaultGroupSequenceProvider(Class<T> beanType) {
        Class<? extends DefaultGroupSequenceProvider<?>> providerClass = this.defaultGroupSequenceProviders.get(beanType);
        return providerClass;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConstraintMapping");
        sb.append("{cascadeConfig=").append(this.cascadeConfig);
        sb.append(", methodCascadeConfig=").append(this.methodCascadeConfig);
        sb.append(", constraintConfig=").append(this.constraintConfig);
        sb.append(", configuredClasses=").append(this.configuredClasses);
        sb.append(", defaultGroupSequences=").append(this.defaultGroupSequences);
        sb.append('}');
        return sb.toString();
    }

    public final void addCascadeConfig(BeanConstraintLocation cascade) {
        Class<?> beanClass = cascade.getBeanClass();
        this.configuredClasses.add(beanClass);
        if (this.cascadeConfig.containsKey(beanClass)) {
            this.cascadeConfig.get(beanClass).add(cascade);
        } else {
            HashSet cascadeList = CollectionHelper.newHashSet();
            cascadeList.add(cascade);
            this.cascadeConfig.put(beanClass, cascadeList);
        }
    }

    public final void addMethodCascadeConfig(MethodConstraintLocation cascade) {
        Class<?> beanClass = cascade.getBeanClass();
        this.configuredClasses.add(beanClass);
        if (this.methodCascadeConfig.containsKey(beanClass)) {
            this.methodCascadeConfig.get(beanClass).add(cascade);
        } else {
            HashSet cascadeList = CollectionHelper.newHashSet();
            cascadeList.add(cascade);
            this.methodCascadeConfig.put(beanClass, cascadeList);
        }
    }

    public final void addDefaultGroupSequence(Class<?> beanClass, List<Class<?>> defaultGroupSequence) {
        this.configuredClasses.add(beanClass);
        this.defaultGroupSequences.put(beanClass, defaultGroupSequence);
    }

    public final <T> void addDeprecatedDefaultGroupSequenceProvider(Class<T> beanClass, Class<? extends org.hibernate.validator.group.DefaultGroupSequenceProvider<? super T>> defaultGroupSequenceProviderClass) {
        this.configuredClasses.add(beanClass);
        this.deprecatedDefaultGroupSequenceProviders.put(beanClass, defaultGroupSequenceProviderClass);
    }

    public final <T> void addDefaultGroupSequenceProvider(Class<T> beanClass, Class<? extends DefaultGroupSequenceProvider<? super T>> defaultGroupSequenceProviderClass) {
        this.configuredClasses.add(beanClass);
        this.defaultGroupSequenceProviders.put(beanClass, defaultGroupSequenceProviderClass);
    }

    public final void addConstraintConfig(ConfiguredConstraint<?, BeanConstraintLocation> constraint) {
        Class<?> beanClass = constraint.getLocation().getBeanClass();
        this.configuredClasses.add(beanClass);
        if (this.constraintConfig.containsKey(beanClass)) {
            this.constraintConfig.get(beanClass).add(constraint);
        } else {
            HashSet definitionList = CollectionHelper.newHashSet();
            definitionList.add(constraint);
            this.constraintConfig.put(beanClass, definitionList);
        }
    }

    public final void addMethodConstraintConfig(ConfiguredConstraint<?, MethodConstraintLocation> constraint) {
        Class<?> beanClass = constraint.getLocation().getBeanClass();
        this.configuredClasses.add(beanClass);
        if (this.methodConstraintConfig.containsKey(beanClass)) {
            this.methodConstraintConfig.get(beanClass).add(constraint);
        } else {
            HashSet definitionList = CollectionHelper.newHashSet();
            definitionList.add(constraint);
            this.methodConstraintConfig.put(beanClass, definitionList);
        }
    }
}

