/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util;

import java.io.InputStream;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public final class ResourceLoaderHelper {
    private static final Log log = LoggerFactory.make();

    public static InputStream getInputStreamForPath(String path) {
        String inputPath = path;
        if (inputPath.startsWith("/")) {
            inputPath = inputPath.substring(1);
        }
        boolean isContextCL = true;
        ClassLoader loader = ReflectionHelper.getClassLoaderFromContext();
        if (loader == null) {
            log.debug("No default context class loader, fall back to Bean Validation's loader");
            loader = ReflectionHelper.getClassLoaderFromClass(ResourceLoaderHelper.class);
            isContextCL = false;
        }
        InputStream inputStream = loader.getResourceAsStream(inputPath);
        if (isContextCL && inputStream == null) {
            loader = ReflectionHelper.getClassLoaderFromClass(ResourceLoaderHelper.class);
            inputStream = loader.getResourceAsStream(inputPath);
        }
        return inputStream;
    }
}

