/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.cdi.interceptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.util.AnnotationLiteral;
import org.hibernate.validator.internal.cdi.interceptor.MethodValidated;
import org.hibernate.validator.internal.cdi.interceptor.ValidationEnabledAnnotatedConstructor;
import org.hibernate.validator.internal.cdi.interceptor.ValidationEnabledAnnotatedMethod;
import org.hibernate.validator.internal.util.CollectionHelper;

public class ValidationEnabledAnnotatedType<T>
implements AnnotatedType<T> {
    private final AnnotatedType<T> wrappedType;
    private final Set<AnnotatedMethod<? super T>> wrappedMethods;
    private final Set<AnnotatedConstructor<T>> wrappedConstructors;
    private final AnnotationLiteral<MethodValidated> methodValidationAnnotation;

    public ValidationEnabledAnnotatedType(AnnotatedType<T> type, Set<AnnotatedCallable<? super T>> constrainedCallables) {
        this.wrappedType = type;
        this.wrappedMethods = CollectionHelper.newHashSet();
        this.wrappedConstructors = CollectionHelper.newHashSet();
        this.buildWrappedCallable(constrainedCallables);
        boolean containsWrappedConstructor = false;
        for (AnnotatedConstructor<T> constructor : this.wrappedConstructors) {
            if (!(constructor instanceof ValidationEnabledAnnotatedConstructor)) continue;
            containsWrappedConstructor = true;
        }
        this.methodValidationAnnotation = containsWrappedConstructor ? new AnnotationLiteral<MethodValidated>(){} : null;
    }

    public Class<T> getJavaClass() {
        return this.wrappedType.getJavaClass();
    }

    public Set<AnnotatedConstructor<T>> getConstructors() {
        return this.wrappedConstructors;
    }

    public Set<AnnotatedMethod<? super T>> getMethods() {
        return this.wrappedMethods;
    }

    public Set<AnnotatedField<? super T>> getFields() {
        return this.wrappedType.getFields();
    }

    public Type getBaseType() {
        return this.wrappedType.getBaseType();
    }

    public Set<Type> getTypeClosure() {
        return this.wrappedType.getTypeClosure();
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        if (MethodValidated.class.equals(annotationType) && this.methodValidationAnnotation != null) {
            AnnotationLiteral<MethodValidated> annotation = this.methodValidationAnnotation;
            return (A)annotation;
        }
        return (A)this.wrappedType.getAnnotation(annotationType);
    }

    public Set<Annotation> getAnnotations() {
        HashSet<Annotation> annotations = new HashSet<Annotation>(this.wrappedType.getAnnotations());
        if (this.methodValidationAnnotation != null) {
            annotations.add((Annotation)this.methodValidationAnnotation);
        }
        return annotations;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        if (MethodValidated.class.equals(annotationType) && this.methodValidationAnnotation != null) {
            return true;
        }
        return this.wrappedType.isAnnotationPresent(annotationType);
    }

    private void buildWrappedCallable(Set<AnnotatedCallable<? super T>> constrainedCallables) {
        for (AnnotatedConstructor constructor : this.wrappedType.getConstructors()) {
            if (constrainedCallables.contains(constructor)) {
                ValidationEnabledAnnotatedConstructor wrappedConstructor = new ValidationEnabledAnnotatedConstructor(constructor);
                this.wrappedConstructors.add(wrappedConstructor);
                continue;
            }
            this.wrappedConstructors.add(constructor);
        }
        for (AnnotatedMethod method : this.wrappedType.getMethods()) {
            if (constrainedCallables.contains(method)) {
                ValidationEnabledAnnotatedMethod wrappedMethod = this.wrap(method);
                this.wrappedMethods.add(wrappedMethod);
                continue;
            }
            this.wrappedMethods.add(method);
        }
    }

    private <U> ValidationEnabledAnnotatedMethod<U> wrap(AnnotatedMethod<U> method) {
        return new ValidationEnabledAnnotatedMethod<U>(method);
    }
}

