/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.descriptor;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstructorDescriptor;
import javax.validation.metadata.MethodDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.descriptor.ElementDescriptorImpl;
import org.hibernate.validator.internal.metadata.descriptor.ExecutableDescriptorImpl;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.logging.Messages;

public class BeanDescriptorImpl
extends ElementDescriptorImpl
implements BeanDescriptor {
    private final Map<String, PropertyDescriptor> constrainedProperties;
    private final Map<String, ExecutableDescriptorImpl> constrainedMethods;
    private final Map<String, ConstructorDescriptor> constrainedConstructors;

    public BeanDescriptorImpl(Type beanClass, Set<ConstraintDescriptorImpl<?>> classLevelConstraints, Map<String, PropertyDescriptor> constrainedProperties, Map<String, ExecutableDescriptorImpl> constrainedMethods, Map<String, ConstructorDescriptor> constrainedConstructors, boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        super(beanClass, classLevelConstraints, defaultGroupSequenceRedefined, defaultGroupSequence);
        this.constrainedProperties = Collections.unmodifiableMap(constrainedProperties);
        this.constrainedMethods = Collections.unmodifiableMap(constrainedMethods);
        this.constrainedConstructors = Collections.unmodifiableMap(constrainedConstructors);
    }

    public final boolean isBeanConstrained() {
        return this.hasConstraints() || !this.constrainedProperties.isEmpty();
    }

    public boolean hasConstrainedExecutables() {
        return !this.constrainedMethods.isEmpty() || !this.constrainedConstructors.isEmpty();
    }

    public final PropertyDescriptor getConstraintsForProperty(String propertyName) {
        Contracts.assertNotNull(propertyName, "The property name cannot be null");
        return this.constrainedProperties.get(propertyName);
    }

    public final Set<PropertyDescriptor> getConstrainedProperties() {
        return CollectionHelper.newHashSet(this.constrainedProperties.values());
    }

    public ConstructorDescriptor getConstraintsForConstructor(Class<?> ... parameterTypes) {
        return this.constrainedConstructors.get(this.getElementClass().getSimpleName() + Arrays.toString(parameterTypes));
    }

    public Set<ConstructorDescriptor> getConstrainedConstructors() {
        return CollectionHelper.newHashSet(this.constrainedConstructors.values());
    }

    public Set<MethodDescriptor> getConstrainedMethods() {
        for (ExecutableDescriptorImpl constrainedMethod : this.constrainedMethods.values()) {
            constrainedMethod.assertCorrectnessOfConfiguration();
        }
        return CollectionHelper.newHashSet(this.constrainedMethods.values());
    }

    public MethodDescriptor getConstraintsForMethod(String methodName, Class<?> ... parameterTypes) {
        Contracts.assertNotNull(methodName, Messages.MESSAGES.methodNameMustNotBeNull());
        ExecutableDescriptorImpl methodDescriptor = this.constrainedMethods.get(methodName + Arrays.toString(parameterTypes));
        if (methodDescriptor != null) {
            methodDescriptor.assertCorrectnessOfConfiguration();
        }
        return methodDescriptor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BeanDescriptorImpl");
        sb.append("{class='");
        sb.append(this.getElementClass().getSimpleName());
        sb.append("'}");
        return sb.toString();
    }
}

