/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util.privilegedactions;

import java.security.PrivilegedAction;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public final class LoadClass
implements PrivilegedAction<Class<?>> {
    private static final Log log = LoggerFactory.make();
    private static final String HIBERNATE_VALIDATOR_CLASS_NAME = "org.hibernate.validator";
    private final String className;
    private final ClassLoader classLoader;

    public static LoadClass action(String className, ClassLoader classLoader) {
        return new LoadClass(className, classLoader);
    }

    private LoadClass(String className, ClassLoader classLoader) {
        this.className = className;
        this.classLoader = classLoader;
    }

    @Override
    public Class<?> run() {
        if (this.className.startsWith(HIBERNATE_VALIDATOR_CLASS_NAME)) {
            return this.loadClassInValidatorNameSpace();
        }
        return this.loadNonValidatorClass();
    }

    private Class<?> loadClassInValidatorNameSpace() {
        try {
            return Class.forName(this.className, true, HibernateValidator.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                return Class.forName(this.className, false, contextClassLoader);
            }
            throw log.getUnableToLoadClassException(this.className);
        }
        catch (ClassNotFoundException e) {
            throw log.getUnableToLoadClassException(this.className, e);
        }
    }

    private Class<?> loadNonValidatorClass() {
        try {
            if (this.classLoader != null) {
                return Class.forName(this.className, false, this.classLoader);
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                return Class.forName(this.className, false, contextClassLoader);
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            return Class.forName(this.className, true, LoadClass.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw log.getUnableToLoadClassException(this.className, e);
        }
    }
}

