/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.hql.ast.spi.AstProcessingChain;
import org.hibernate.hql.ast.spi.AstProcessor;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.QueryRendererDelegate;
import org.hibernate.hql.ast.spi.QueryRendererProcessor;
import org.hibernate.hql.ast.spi.QueryResolverDelegate;
import org.hibernate.hql.ast.spi.QueryResolverProcessor;
import org.hibernate.hql.lucene.LuceneQueryParsingResult;
import org.hibernate.hql.lucene.internal.LuceneQueryRendererDelegate;
import org.hibernate.hql.lucene.internal.LuceneQueryResolverDelegate;
import org.hibernate.search.spi.SearchFactoryIntegrator;

public class LuceneProcessingChain
implements AstProcessingChain<LuceneQueryParsingResult> {
    private final QueryResolverProcessor resolverProcessor;
    private final QueryRendererProcessor rendererProcessor;
    private final LuceneQueryRendererDelegate rendererDelegate;

    public LuceneProcessingChain(SearchFactoryIntegrator searchFactory, EntityNamesResolver entityNames, Map<String, Object> namedParameters) {
        this.resolverProcessor = new QueryResolverProcessor((QueryResolverDelegate)new LuceneQueryResolverDelegate(searchFactory, entityNames, namedParameters));
        LuceneQueryRendererDelegate rendererDelegate = new LuceneQueryRendererDelegate(searchFactory, entityNames, namedParameters);
        this.rendererProcessor = new QueryRendererProcessor((QueryRendererDelegate)rendererDelegate);
        this.rendererDelegate = rendererDelegate;
    }

    public Iterator<AstProcessor> iterator() {
        return Arrays.asList(this.resolverProcessor, this.rendererProcessor).iterator();
    }

    public LuceneQueryParsingResult getResult() {
        return this.rendererDelegate.getResult();
    }
}

