/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.hibernate.hql.ast.common.JoinType;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReferenceSource;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.QueryRendererDelegate;
import org.hibernate.hql.lucene.LuceneQueryParsingResult;
import org.hibernate.hql.lucene.internal.builder.LuceneQueryBuilder;
import org.hibernate.hql.lucene.internal.builder.PropertyHelper;
import org.hibernate.search.spi.SearchFactoryIntegrator;

public class LuceneQueryRendererDelegate
implements QueryRendererDelegate<LuceneQueryParsingResult> {
    private final Map<String, String> aliasToEntityType = new HashMap<String, String>();
    private Status status;
    private final EntityNamesResolver entityNames;
    private Class<?> targetType = null;
    private final Map<String, Object> namedParameters;
    private final LuceneQueryBuilder builder;
    private PropertyPath propertyPath;
    private final List<String> projections = new ArrayList<String>();

    public LuceneQueryRendererDelegate(SearchFactoryIntegrator searchFactory, EntityNamesResolver entityNames, Map<String, Object> namedParameters) {
        this.entityNames = entityNames;
        this.namedParameters = namedParameters;
        this.builder = new LuceneQueryBuilder(searchFactory.buildQueryBuilder(), new PropertyHelper(searchFactory));
    }

    public void registerPersisterSpace(Tree entityName, Tree alias) {
        String put = this.aliasToEntityType.put(alias.getText(), entityName.getText());
        if (put != null && !put.equalsIgnoreCase(entityName.getText())) {
            throw new UnsupportedOperationException("Alias reuse currently not supported: alias " + alias.getText() + " already assigned to type " + put);
        }
        Class targetedType = this.entityNames.getClassFromName(entityName.getText());
        if (targetedType == null) {
            throw new IllegalStateException("Unknown entity name " + entityName.getText());
        }
        if (this.targetType != null) {
            throw new IllegalStateException("Can't target multiple types: " + this.targetType + " already selected before " + targetedType);
        }
        this.targetType = targetedType;
        this.builder.setEntityType(targetedType);
    }

    public boolean isUnqualifiedPropertyReference() {
        return true;
    }

    public boolean isPersisterReferenceAlias() {
        if (this.aliasToEntityType.size() == 1) {
            return true;
        }
        throw new UnsupportedOperationException("Unexpected use case: not implemented yet?");
    }

    public void pushFromStrategy(JoinType joinType, Tree assosiationFetchTree, Tree propertyFetchTree, Tree alias) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void pushSelectStrategy() {
        this.status = Status.DEFINING_SELECT;
    }

    public void popStrategy() {
        this.status = null;
    }

    public void activateOR() {
        this.builder.pushOrPredicate();
    }

    public void activateAND() {
        this.builder.pushAndPredicate();
    }

    public void activateNOT() {
        this.builder.pushNotPredicate();
    }

    public void predicateEquals(String comparativePredicate) {
        Object comparisonValue = this.fromNamedQuery(comparativePredicate);
        this.builder.addEqualsPredicate(this.propertyPath.getNodeNamesWithoutAlias(), comparisonValue);
    }

    public void predicateBetween(String lower, String upper) {
        Object lowerComparisonValue = this.fromNamedQuery(lower);
        Object upperComparisonValue = this.fromNamedQuery(upper);
        this.builder.addRangePredicate(this.propertyPath.getNodeNamesWithoutAlias(), lowerComparisonValue, upperComparisonValue);
    }

    private Object fromNamedQuery(String comparativePredicate) {
        if (comparativePredicate.startsWith(":")) {
            return this.namedParameters.get(comparativePredicate.substring(1));
        }
        return comparativePredicate;
    }

    public void deactivateBoolean() {
        this.builder.popBooleanPredicate();
    }

    public LuceneQueryParsingResult getResult() {
        return new LuceneQueryParsingResult(this.builder.build(), this.targetType, this.projections);
    }

    public void setPropertyPath(PropertyPath propertyPath) {
        if (this.status == Status.DEFINING_SELECT) {
            if (propertyPath.getNodes().size() == 1 && ((PathedPropertyReferenceSource)propertyPath.getNodes().get(0)).isAlias()) {
                this.projections.add("__HSearch_This");
            } else {
                this.projections.add(propertyPath.asStringPathWithoutAlias());
            }
        } else {
            this.propertyPath = propertyPath;
        }
    }

    private static enum Status {
        DEFINING_SELECT,
        DEFINING_FROM;

    }
}

