/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.hibernate.hql.ast.TypeDescriptor;
import org.hibernate.hql.ast.common.JoinType;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReference;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReferenceSource;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.QueryResolverDelegate;
import org.hibernate.hql.lucene.internal.ast.HSearchEmbeddedEntityTypeDescriptor;
import org.hibernate.hql.lucene.internal.ast.HSearchIndexedEntityTypeDescriptor;
import org.hibernate.hql.lucene.internal.ast.HSearchPropertyTypeDescriptor;
import org.hibernate.hql.lucene.internal.ast.HSearchTypeDescriptor;
import org.hibernate.hql.lucene.internal.builder.PropertyHelper;
import org.hibernate.hql.lucene.internal.logging.Log;
import org.hibernate.hql.lucene.internal.logging.LoggerFactory;
import org.hibernate.search.spi.SearchFactoryIntegrator;

public class LuceneQueryResolverDelegate
implements QueryResolverDelegate {
    private static final Log log = LoggerFactory.make();
    private final Map<String, String> aliasToEntityType = new HashMap<String, String>();
    private Status status;
    private final EntityNamesResolver entityNames;
    private final PropertyHelper propertyHelper;
    private Class<?> targetType = null;

    public LuceneQueryResolverDelegate(SearchFactoryIntegrator searchFactory, EntityNamesResolver entityNames, Map<String, Object> namedParameters) {
        this.entityNames = entityNames;
        this.propertyHelper = new PropertyHelper(searchFactory);
    }

    public void registerPersisterSpace(Tree entityName, Tree alias) {
        String put = this.aliasToEntityType.put(alias.getText(), entityName.getText());
        if (put != null && !put.equalsIgnoreCase(entityName.getText())) {
            throw new UnsupportedOperationException("Alias reuse currently not supported: alias " + alias.getText() + " already assigned to type " + put);
        }
        Class targetedType = this.entityNames.getClassFromName(entityName.getText());
        if (targetedType == null) {
            throw new IllegalStateException("Unknown entity name " + entityName.getText());
        }
        if (this.targetType != null) {
            throw new IllegalStateException("Can't target multiple types: " + this.targetType + " already selected before " + targetedType);
        }
        this.targetType = targetedType;
    }

    public boolean isUnqualifiedPropertyReference() {
        return true;
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedPropertyReference(Tree property) {
        if (this.aliasToEntityType.containsKey(property.getText())) {
            return this.normalizeQualifiedRoot(property);
        }
        return this.normalizeProperty(new HSearchIndexedEntityTypeDescriptor(this.targetType, this.propertyHelper), Collections.<String>emptyList(), property.getText());
    }

    public boolean isPersisterReferenceAlias() {
        if (this.aliasToEntityType.size() == 1) {
            return true;
        }
        throw new UnsupportedOperationException("Unexpected use case: not implemented yet?");
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedRoot(Tree identifier382) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public PathedPropertyReferenceSource normalizeQualifiedRoot(Tree root) {
        String entityNameForAlias = this.aliasToEntityType.get(root.getText());
        if (entityNameForAlias == null) {
            throw log.getUnknownAliasException(root.getText());
        }
        Class entityType = this.entityNames.getClassFromName(entityNameForAlias);
        return new PathedPropertyReference(root.getText(), (TypeDescriptor)new HSearchIndexedEntityTypeDescriptor(entityType, this.propertyHelper), true);
    }

    public PathedPropertyReferenceSource normalizePropertyPathIntermediary(PropertyPath path, Tree propertyName) {
        HSearchTypeDescriptor sourceType = (HSearchTypeDescriptor)path.getLastNode().getType();
        if (!sourceType.hasProperty(propertyName.getText())) {
            throw log.getNoSuchPropertyException(sourceType.toString(), propertyName.getText());
        }
        LinkedList<String> newPath = new LinkedList<String>(path.getNodeNamesWithoutAlias());
        newPath.add(propertyName.getText());
        PathedPropertyReference property = new PathedPropertyReference(propertyName.getText(), (TypeDescriptor)new HSearchEmbeddedEntityTypeDescriptor(sourceType.getIndexedEntityType(), newPath, this.propertyHelper), false);
        return property;
    }

    public PathedPropertyReferenceSource normalizeIntermediateIndexOperation(PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty, Tree selector) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void normalizeTerminalIndexOperation(PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty, Tree selector) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public PathedPropertyReferenceSource normalizeUnqualifiedPropertyReferenceSource(Tree identifier394) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public PathedPropertyReferenceSource normalizePropertyPathTerminus(PropertyPath path, Tree propertyNameNode) {
        return this.normalizeProperty((HSearchTypeDescriptor)path.getLastNode().getType(), path.getNodeNamesWithoutAlias(), propertyNameNode.getText());
    }

    private PathedPropertyReferenceSource normalizeProperty(HSearchTypeDescriptor type, List<String> path, String propertyName) {
        if (!type.hasProperty(propertyName)) {
            throw log.getNoSuchPropertyException(type.toString(), propertyName);
        }
        if (this.status != Status.DEFINING_SELECT && type.isAnalyzed(propertyName)) {
            throw log.getQueryOnAnalyzedPropertyNotSupportedException(type.getIndexedEntityType().getCanonicalName(), propertyName);
        }
        if (type.isEmbedded(propertyName)) {
            LinkedList<String> newPath = new LinkedList<String>(path);
            newPath.add(propertyName);
            return new PathedPropertyReference(propertyName, (TypeDescriptor)new HSearchEmbeddedEntityTypeDescriptor(type.getIndexedEntityType(), newPath, this.propertyHelper), false);
        }
        return new PathedPropertyReference(propertyName, (TypeDescriptor)new HSearchPropertyTypeDescriptor(), false);
    }

    public void pushFromStrategy(JoinType joinType, Tree assosiationFetchTree, Tree propertyFetchTree, Tree alias) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void pushSelectStrategy() {
        this.status = Status.DEFINING_SELECT;
    }

    public void popStrategy() {
        this.status = null;
    }

    public void propertyPathCompleted(PropertyPath path) {
        if (this.status == Status.DEFINING_SELECT && path.getLastNode().getType() instanceof HSearchEmbeddedEntityTypeDescriptor) {
            HSearchEmbeddedEntityTypeDescriptor type = (HSearchEmbeddedEntityTypeDescriptor)path.getLastNode().getType();
            throw log.getProjectionOfCompleteEmbeddedEntitiesNotSupportedException(type.getIndexedEntityType().getCanonicalName(), path.asStringPathWithoutAlias());
        }
    }

    private static enum Status {
        DEFINING_SELECT,
        DEFINING_FROM;

    }
}

