/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene.internal.ast;

import java.util.LinkedList;
import java.util.List;
import org.hibernate.hql.lucene.internal.ast.HSearchTypeDescriptor;
import org.hibernate.hql.lucene.internal.builder.PropertyHelper;

public class HSearchEmbeddedEntityTypeDescriptor
implements HSearchTypeDescriptor {
    private final Class<?> indexedEntityType;
    private final List<String> propertyPath;
    private final PropertyHelper propertyHelper;

    public HSearchEmbeddedEntityTypeDescriptor(Class<?> indexedEntityType, List<String> path, PropertyHelper propertyHelper) {
        this.indexedEntityType = indexedEntityType;
        this.propertyPath = path;
        this.propertyHelper = propertyHelper;
    }

    public boolean hasProperty(String propertyName) {
        LinkedList<String> newPath = new LinkedList<String>(this.propertyPath);
        newPath.add(propertyName);
        return this.propertyHelper.exists(this.indexedEntityType, newPath);
    }

    @Override
    public boolean isAnalyzed(String propertyName) {
        LinkedList<String> newPath = new LinkedList<String>(this.propertyPath);
        newPath.add(propertyName);
        return this.propertyHelper.isAnalyzed(this.indexedEntityType, newPath);
    }

    @Override
    public boolean isEmbedded(String propertyName) {
        LinkedList<String> newPath = new LinkedList<String>(this.propertyPath);
        newPath.add(propertyName);
        return this.propertyHelper.isEmbedded(this.indexedEntityType, newPath);
    }

    @Override
    public Class<?> getIndexedEntityType() {
        return this.indexedEntityType;
    }

    public String toString() {
        return this.propertyPath.toString();
    }
}

